function IV=SBvar_pos(n,maxvar)
% function IV=SBvar_pos(n,maxvar)
% gibt in IV die Position der Variablen
% Druck, Temperatur,Leitfhigkeit, Salz, Sauerstoff, Ox.current und Ox.Temperatur
% aus. Falls nicht vorhanden wird erstmal nach den mglichen Namen nachgefragt
% (diese werden von Aufruf nach Aufruf in der globalen Variablen 
%  SBVariablennamen beibehalten).
% Falls dann nicht vorhanden gesetzt, wird auf der Position 0 ausgegeben.
% wird maxvar gesetzt, werden nur die ersten maxvar Variablen
% gesucht (interesant ist hierbeihauptschlich maxvar=3 um nur die
% eigentlich immer gemessenn Parameter Druck,Temp. und
% Leitfhigkeit) zu bestimmen. 
% falls maxvar negativ; werden die Variablennamen alle auf '%&/%&/'
% gesetzt, dadurch sollte immer nachgefragt werden.


if nargin<2; maxvar=7; end
if iscell(n); n=char(n); end
if ~isstr(n); error('SBvar_pos, Eingabe muss Stringarray sein');end
[mm_n,nn_n]=size(n);

Variablennamen={'pressure','temperature','conductivity','salinity','oxygen','ox.Current','ox.temp.'};
global SBVariablennamen
if isempty(SBVariablennamen);
    %SBVariablennamen.PRES={'PRES','pressure'};
    %SBVariablennamen.TEMP={'TEMP','temperature'};
    %SBVariablennamen.COND={'COND','conductivity'};
    %SBVariablennamen.S   ={'S','salinity'};
    %SBVariablennamen.OXYG={'OXYG','oxygen'};
    %SBVariablennamen.oxC ={'oxC','ox.Current'};
    %SBVariablennamen.oxT ={'oxT','ox.temp.'};
    SBVariablennamen(1).name={'PRES','pressure'};
    SBVariablennamen(2).name={'TEMP','temperature'};
    SBVariablennamen(3).name={'COND','conductivity'};
    SBVariablennamen(4).name={'S','salinity'};
    SBVariablennamen(5).name={'OXYG','oxygen'};
    SBVariablennamen(6).name={'oxC','ox.Current'};
    SBVariablennamen(7).name={'oxT','ox.temp.'};
    for I=1:7; SBVariablennamen(I).no={'%&/%&/'}; end
    %SBVariablennamen={'PRES','TEMP','COND','S','OXYG','oxC','oxT'};
end
if maxvar<0; 
    %    SBVariablennamen={'%&/%&/','%&/%&/','%&/%&/','%&/%&/','%&/%&/','%&/%&/','%&/%&/'};
    maxvar=abs(maxvar);
end
maxvar=min(7,maxvar);

%nn=[ cellstr(n);{'nicht vorhanden'}];
inn=0;
for K=1:mm_n
    for I=1:7
        Ivar=[];
        for J=1:length(SBVariablennamen(I).name)
            Ivar=strmatch(SBVariablennamen(I).name{J},n(K,:));
            if ~isempty(Ivar); break; end
        end
        if ~isempty(Ivar); break; end
    end
    if isempty(Ivar); inn=inn+1; nn(inn)={n(K,:)}; jnn(inn)=K; end
end
inn=inn+1; nn(inn)={'nicht vorhanden'};

IV=zeros(1,7);  
for I=1:maxvar
    Ivar=[];
    lennam=length(SBVariablennamen(I).name);
    for J=1:lennam
        Ivar=strmatch(SBVariablennamen(I).name{J},n);
        if ~isempty(Ivar); IV(I)=Ivar(1); break; end
    end
    if isempty(Ivar) & inn>1
        knn=0; 
        for J=1:inn-1
            Nnn=deblank(nn(J));
            Ivar=strmatch(Nnn,SBVariablennamen(I).no);
            if ~isempty(Ivar); knn=knn+1; end
        end
        if knn~=inn-1
            IV(I)=menu([char(Variablennamen(I)) ' variable:'],nn);
            if IV(I)>inn-1;
                ll=length(SBVariablennamen(I).no);
                IV(I)=0; 
                for jj=1:inn-1
                    SBVariablennamen(I).no(ll+jj)=deblank(nn(jj));
                end
            else 
                SBVariablennamen(I).name(lennam+1)=deblank(nn(IV(I)));
                IV(I)=jnn(IV(I));
            end
        end
    end   
    %    if ~isempty(strmatch(SBVariablennamen(I),'nicht vorhanden'))
    %        IV(I)=0;
    %    else
    %        Ivar=strmatch(SBVariablennamen(I),n);
    %        if isempty(Ivar); 
    %            IV(I)=menu([char(Variablennamen(I)) ' variable:'],nn);
    %            SBVariablennamen(I)=nn(IV(I));
    %            if IV(I)>mm_n; IV(I)=0; end
    %        else IV(I)=Ivar(1); end
    %    end
end

