function [A,Xout]=anpapp(a,b,Xa,Xb,extent)
% a call with 3 input arguments is equivalent to (a,b,extent)
% puts A=[a b] regardless of size of a,b
% size 1 of results is always max of a,b
% shorter data will be extended with NaN
% exept is extent='x' or 'y'
% extent='x' extend with the nearest data in x-direction
% extent='y' dito in y (column) direction
% 
% if Xa and Xb are given the output matrix has values at
% all unique elemts of Xa and XB in ascending order
% e.g.
%  Xa              Xb                Xout
%  [1 2 3]         [2 3 4 5]         [1 2 3 4 5]
%  [1 3 5]         [2 3 4 5]         [1 2 3 4 5]
%  [1 5]           [2 37 25]         [1 2 5 25 37]

ia=size(a);
ib=size(b);

if nargin<=3 
 if nargin==3; extent=Xa; end
 if exist('extent')~=1; extent='n'; end
 if ia(1)>=ib(1)
   A=[a NaN+zeros(ia(1),ib(2))];
   A(1:ib(1),ia(2)+1:ia(2)+ib(2))=b;
   if ia(1)~=ib(1)
      if extent=='y'; 
         A(ib(1)+1:end,ia(2)+1:ia(2)+ib(2))=ones(ia(1)-ib(1),1)*b(ib(1),:);
      end
      if extent=='x'; 
         A(ib(1)+1:end,ia(2)+1:ia(2)+ib(2))=repmat(a(ib(1)+1:end,end),1,ib(2));
      end
   end   
 else
    A=[NaN+zeros(ib(1),ia(2)) b];
    A(1:ia(1),1:ia(2))=a;
    if extent=='y'; 
      A(ia(1)+1:end,1:ia(2))=ones(ib(1)-ia(1),1)*a(ia(1),:);
   end
   if extent=='x'; 
      A(ia(1)+1:end,1:ia(2))=repmat(b(ia(1)+1:end,1),1,ia(2));
    end
 end
else
    iXa=size(Xa); 
    if min(iXa)~=1 | length(iXa)>2; error('falsche Dimension Xa'); end
    if iXa(1)<iXa(2); Xa=Xa'; end 
    iXb=size(Xb);    
    if min(iXb)~=1 | length(iXb)>2; error('falsche Dimension Xb'); end
    if iXb(1)<iXb(2); Xb=Xb'; end 
    Xout=sort([Xa;Xb]);
    for ii=length(Xout):-1:2
        if Xout(ii)==Xout(ii-1); Xout(ii)=[]; end
    end
    if ia(2)==max(iXa); a=a'; ia=size(a); 
    elseif ia(1)~=max(iXa); error('a und xa muessen gleich gross sein');end
    if ib(2)==max(iXb); b=b'; ib=size(b); 
    elseif ib(1)~=max(iXb); error('b und xb muessen gleich gross sein');end
   A=zeros(length(Xout),ia(2)+ib(2))+NaN;
    nn=[];
    for ii=1:ia(1)
        mm=find(Xa(ii)==Xout);
        if length(mm)>1; warning('anpapp, mehrdeutige Xa'); end
        nn=[nn mm];
    end
    A(nn,1:ia(2))=a; 
    nn=[];
    for ii=1:ib(1)
        mm=find(Xb(ii)==Xout);
        if length(mm)>1; warning('anpapp, mehrdeutige Xb'); end
        nn=[nn mm];
    end
    A(nn,ia(2)+1:ia(2)+ib(2))=b;
  
end