function A=arrfill(a,kabkling)
% von links durch das Array gehend, verlaengert es
% kuerzere Profile (=columns) mit den Daten des laengeren
% profil, das kuezere gleicht sich innerhalb 400 Zyklen
% linear dem laengeren an.
% Ganz einfache routinen zur Verwendung bei section.m
ii=size(a);
if exist('kabkling')~=1; kabkling=min([ii(1) 400]); end
A=a;
if kabkling==0;
    kk=0
else
    kk=-1/abs(kabkling);
end
abkling=[ [1+kk:kk:0] zeros(1,ii(1))];

% erstmal NaN innerhalb eines Profils interpolieren
for mm=1:ii(2)
K1=min(find(~isnan(a(:,mm))));
K2=max(find(~isnan(a(:,mm))));
K=isnan(a(:,mm)); jj=sum(K(K1:K2));
if jj>0;
    jj=[1:ii(1)]; kk=K; kk(1:K1)=0; kk(K2:end)=0;
    kk=find(kk);
    A(kk,mm)=interp1(jj(~K),a(~K,mm),kk);
end
end
% bestimmen von nn= erstes vorkommen von NaN in einem Profil
% und das ganze fuer alle profile
for mm=1:ii(2)
   K=min(find(isnan(a(:,mm))));
   if isempty(K); K=ii(1)+1; end
   if K==1
     K=min(find(~isnan(a(:,mm))));
     A(1:K-1,mm)=A(K,mm);
     K=min(find(isnan(A(:,mm))));
     if isempty(K); K=ii(1)+1; end
   end
   if K==1; K=2; end; % dies falls alles NN (oder nur ein Wert?)
   nn(mm)=K;
end

% Verlaengeren des vorherigen profils
for mm=2:ii(2)
   if nn(mm)>nn(mm-1)
      D=A(nn(mm-1)-1,mm-1) - A(nn(mm-1)-1,mm);
      Aunten=A(nn(mm-1):nn(mm)-1,mm) ...
         + abkling(1:nn(mm)-nn(mm-1))'*D;
      Amax=max([A(nn(mm-1):nn(mm)-1,mm)' A(nn(mm-1)-1,mm-1)]);
      Amin=min([A(nn(mm-1):nn(mm)-1,mm)' A(nn(mm-1)-1,mm-1)]);
      iim=Aunten<Amin; Aunten(iim)=Amin;
      iim=Aunten>Amax; Aunten(iim)=Amax;
      A(nn(mm-1):nn(mm)-1,mm-1)=Aunten;
   end
end

% Verlaengeren des folgenden profils
for mm=1:ii(2)-1
   if nn(mm)>nn(mm+1)
      D=A(nn(mm+1)-1,mm+1) - A(nn(mm+1)-1,mm);
      Aunten=A(nn(mm+1):nn(mm)-1,mm) ...
         + abkling(1:nn(mm)-nn(mm+1))'*D;
      Amax=max([A(nn(mm+1):nn(mm)-1,mm)' A(nn(mm+1)-1,mm+1)]);
      Amin=min([A(nn(mm+1):nn(mm)-1,mm)' A(nn(mm+1)-1,mm+1)]);
      iim=Aunten<Amin; Aunten(iim)=Amin;
      iim=Aunten>Amax; Aunten(iim)=Amax;
      A(nn(mm+1):nn(mm)-1,mm+1)=Aunten;

   end
end

% falls erwuenscht alles konstant verlaengern
if kabkling<0; 
  for mm=1:ii(2)
    K=min(find(isnan(A(:,mm))));
    if ~isempty(K)
      A(K:ii(1),mm)=A(K-1,mm);
    end 
  end
end
