function cond=celltm(c,t,time)
% cond ist die thermal mass corrected conductivity
% c ist die gemessene Leitfhigkeit
% t ist die temperatur und
% time ist die Zeit in sekunden
     alpha=0.04;
     beta=1/8;
     ctm=0;
     cond=c;
     for i=2:length(c)
      dt=t(i)-t(i-1);
      a=2*alpha/( (time(i)-time(i-1))*beta + 2 );
      b= 1 - (2*a/alpha);
      dcdt= 0.1*(1 + 0.006*(t(i)-20));
      ctm=-1.0*b*ctm + a*dcdt*dt;
      cond(i)=cond(i)+ctm;
     end
