function []=dichtecontour(iso,Pref,TPref,varargin)
% function []=dichtecontour(iso,Pref,TPref)
% zeichnet ber dem aktuellen Bild Isolinien der Dichte (sigma_x)
% iso gibt die gewuenschten Isolinien an (bei fehlender Angabe
%     werden sie aus den Daten bestimmt, ebenso falls ansonsten keine
%     Isolinien gezeichnet wuerden)
% Pref gibt die Druckreferenz fr die Dichte an, Standardmig 
%     wird Pref=0 angenommen
% TPref gibt die Druckreferenz der potentiellen Temperatur an,
%     so wie sie auf der Y-Achse aufgetragen wurde. Standardmssig
%     wird=0 angenohmen, d.h. auf der Y-Achse ist die normale pot.
%     Temperatur aufgetragen.
if exist('iso')~=1; iso=[1e32]; end
if isempty(iso); iso=[1e32]; end
if exist('Pref')~=1; Pref=0; end
if isempty(Pref); Pref=0; end
if exist('TPref')~=1; TPref=0; end
if isempty(TPref); TPref=0; end

autolabel=0;
if nargin>3
autolabel=0;
   if findstr(char(vargin{1}),'auto')>0;
autolabel=1; end
end
end

a=axis;
salz=linspace(a(1),a(2),51);
temp=linspace(a(3),a(4),51);
[Salz,Temp]=meshgrid(salz,temp);
R=sw_pden(Salz,Temp,TPref,Pref)-1000;
R2= max(max(R)); R1= min(min(R));
%if R2<min(iso) | R1>max(iso);
if sum(iso>R1 & iso<R2)<2
  iso=[floor(R1*10)/10:0.005:ceil(R2*10)/10];  
  if length(iso)>15; iso=[floor(R1*10)/10:0.01:ceil(R2*10)/10]; end
  if length(iso)>15; iso=[floor(R1*10)/10:0.05:ceil(R2*10)/10]; end
  if length(iso)>15; iso=[floor(R1*10)/10:0.10:ceil(R2*10)/10]; end
  if length(iso)>15; iso=[floor(R1*10)/10:0.25:ceil(R2*10)/10]; end
end
H=ishold;
hold on
C=contour(salz,temp,R,iso,'k');
if ~isempty(C) & autolabel==1
    C=clabel(C,'manual');
    for h=1:length(iso)
        k=findobj(C,'UserData',iso(h));
        set(k,'String',sprintf('%4.2f',iso(h)'));
    end
end
if ~H; hold off; end
