function filt=medianfilter(a,n,r)
% function filt=medianfilter(a,n,r)
%
% medianfilter von a
% Filterlaenge n (d.h. +- n/2)
% falls r angegeben, wird der wert von a nur gegen den
% median ersetzt, falls er mehr als r vom median abweicht.
% bei stetig steigenden, bzw. fallenden Werten wird am Anfang
% und am Ende nicht richtig gefiltert, da der berechnete Median
% von einem verschobenen Intervall herruehrt.
%
% NEUE VErsion
%  bei r=0 wird der Eingabewert mit den Median ersetzt
%  bei r~= nur falls der Eingabewert mehr als abs(r) vom median
%  abweicht
%  bei r<0 geschieht das nur einmal,
%  bei r>0 geschieht dies iterativ
%   erst wird der Median fuer alle Werte berechnet.
%   dann wird der wert mit der groessten Abweichung (>r) ersetzt, die
%   betroffenen Median Werte erneut berechnet und dann sowlange iteriert, 
%   bis alle Abweichungen im erlaubten Bereich sind. 
% J.Holfort Sept.2002
if exist('r')~=1; r=0; end
if r<0; r=0; end
if n<1; n=1; end

[i,j]=size(a);
if i==1; a=a'; [i,j]=size(a); end
filt=a;

N1=fix(n/2); if N1==n/2; N0=N1; else N0=fix((n-0.1)/2); end

for J=1:j
 Nersetzt=0;
 M=a(:,J)+NaN;
 for I=1:i
   MDAT=a(max(1,I-N0):min(i,I+N1),J);
   ii=isnan(MDAT); 
   if sum(ii)>0; MDAT=MDAT(~ii); end
   if sum(~ii)==0;
     M(I)=NaN; 
   else
     M(I)=median(MDAT);
   end
 end
 if r==0         % bei Abweichung=0 wird der median gesetzt
   filt(:,J)=M;
 elseif r<0      % bei Abweichung<0 wird nicht iteriert 
   ii= abs(a(:,j)-M)-abs(r)>0;
   filt(ii,J)=M(ii)
 else   
   [Y,Imax] = max(abs(a(:,j)-M));
   while Y>r
     filt(Imax,J)=M(Imax);
     Nersetzt=Nersetzt+1;
     for I=max(1,Imax-N0):min(i,Imax+N1)
      MDAT=filt(max(1,I-N0):min(i,I+N1),J);
      ii=isnan(MDAT);
      if sum(ii)>0; MDAT=MDAT(~ii); end
      M(I)=median(MDAT);
     end                                                                                               
     [Y,Imax] = max(abs(filt(:,J)-M));
   end
 end 
 if Nersetzt>0; 
   fprintf('Variable:%i;  ersetzte Zyklen:%i\n',J,Nersetzt);
 end
end

