function [out,Dout]=mitteln(in,grid,nn)
% mitteln eines Arrays
% function [out,Dout]=mitteln(in,grid,nn)
% in   Eingabearray, 
% nn   Spalte im Eingabearray, ber dem gemittelt werden soll,
%      bzw. falls genauso lang wie in, die zu in zugehoerige Dimension
%      ueber die gemittelt werden soll. Dann steht in der Extra Ausgabe
%      Dout die gemittlete Werte dieser Dimension
% Grid Bestimmt die Mittelung:
%  1Wert  running mean, der Wert gibt die Intervallbreite frs Mitteln an,
%         jeweils Daten im Bereich +-Wert werden benutzt.
%         Ausgabearray hat auf nn-Spalte die gleichen Werte wie die Eingabe
%         (dies entspricht einer Glaettung). 
%  3Werte min,max,step,...
%         min=max suche aus den daten
%         step=negativ Absolutzahl ist Anzahl sttzpunkte
%           (falls min~=max werden die negativen Eingaben
%           bei sb_ui aber gleich in positive Werte umgerechnet)
%  4Werte die ersten 3 wie oben, der vierte ist der
%         Wert fr die Intervallbreite frs Mitteln.
% >4Werte Angabe der Sttzpunke fr die Interpolation 
%         (so das auch unregelmssige Datenverteilungreturnen
%         vorkommen koennen). 
%         1ster Wert ist die Intervallbreite,
%         2-4 sind bisher unbenutzt
%         alle >4 sind die Sttzstellen

[m_in,n_in]=size(in);
if m_in<1; out=[]; return; end
if nargin<3; nn=1; end
if nn==0; nn=[1:m_in]; end
umdreh=0;  % falls das Ausgabearray transponiert werden muss
if length(nn)>1
   if prod(size(nn))~=length(nn); error('nn muss 1D sein'); end
    if length(nn)~=m_in; 
      if length(nn)==n_in; %
	in=in'; umdreh=1;
	[m_in,n_in]=size(in);
      else
	error('falsches nn'); 
      end
    end
    Extradim=nn; nn=0;
else
    if nn<1; 
        warning('nummer der gewenschten Mittelungsspalte=0 oder kleiner, =1 gesetzt');
        nn=1;
    end
    if nn>n_in; error('nummer der gewenschten Mittelungsspalte zu gross');end
    Extradim=in(:,nn);
end
if length(grid)==1;
    grid(4)=grid(1);
    out=in+NaN;
    Dout=Extradim;
elseif length(grid)>4
    %error('Grid mit mehr als 4 werten noch nicht mglich');end
    Dout=grid(5:end); grid(4)=grid(1);
    out=zeros(length(Dout),n_in)+NaN;
else
    if length(grid)<3; error('Eingabe grid mus mindesten 3 Werte haben'); end
    if length(grid)>4; error('Grid mit mehr als 4 werten noch nicht mglich');end    
    if length(grid)==3; grid(4)=grid(3)/2.; end
    
    if grid(1)>grid(2); grid([1 2])=grid([2 1]); end
    if grid(1)==grid(2);
        grid(1)=min(Extradim); grid(2)=max(Extradim);
        if grid(3)>0;
            grid(1)=floor(grid(1)/grid(3))*grid(3);
            grid(2)= ceil(grid(2)/grid(3))*grid(3);
        end
    end
    if grid(3)<=0
        if grid(3)>-2; grid(3)=-100; end
        grid(3)=(grid(2)-grid(1))/(abs(grid(3))-1);
    end
    if grid(4)<=0; grid(4)=grid(3)*2.; end
    
    m_out=1+(grid(2)-grid(1))/grid(3);
    %kk1=[1:n_in]; kk1(nn)=[];
    if isnan(m_out) | isnan(n_in); out=[];return; end  % 3/2004
    out=ones(floor(m_out),n_in)*NaN;
    Dout=[grid(1):grid(3):grid(2)]';
end
kk1=[1:n_in]; 
if nn>0; kk1(nn)=[]; end

for ii=1:length(Dout)
    jj=find(abs(Extradim-Dout(ii)) <= grid(4));
    if length(jj)>0
        for kk=kk1
            ll=~isnan(in(jj,kk));
            if sum(ll)>0
                out(ii,kk)=mean(in(jj(ll),kk));
            end
        end
    end
end

if nn>0; out(:,nn)=Dout; end

if umdreh==1; out=out'; end
