function [Clin,Hlin]=mk4ins(datei,isol,flat,Sk_text,over,Bodenfarbe,varargin)
%function [Clin,Hlin]=mk4ins(datei,isol,flat,Sk_text,over,Bodenfarbe)
% Zum angenehmen Malen von Contours, Daten entweder aus einem Array
% einer bestimmten Struktur oder einer Netcdf-Datei von MK4INSP 
% Eingabe:
%  datei   : Die netcdf-Ausgabedatei von mk4insp mit den daten auf
%            dem regelmaessigen Gitter
%            kann auch eine Struktur sein mit Elementen:
%            'Grid','Error','OptOrd' (je nach over)
%            'X','Y', (Achsenbereiche), 'Z' (Isolinien)
%            'Boden', x*2 Matrix falls Bodentopographie erwnscht
%            'Data', x*2 Matrix falls Datenpunkte erwnscht
%            oder ein einfaches Array (wird auf 'Grid' kopiert)
%            bzw, ein cell Array 1->X; 2->Y;3->Grid;
%  isol    : Isolinien z.B. [0:1:10 12:2:30]
%            oder Isolinien und entsprechende Farbe
%             z.B. [[0:1:10 12:2:30];jet(21)']  
%            oder Isolinien und entsprechender Linienstil 
%             z.B. [[0:1:10 12:2:30];ones(2,21)']  
%  flat    : Art der conturierung
%          -1 pcolor flat + isolinien
%           0 pcolor interpoliert + isolinien
%           1 farbig gefllt+isolinien 
%           2 nur Iso-Linien (SW, contour)
%           3 farbig gefllt (contourf)
%           bei Farbdartstellung erscheint eine SKALA am rechten Bildrand
% Bis hierhin werden die Parameter, falls nicht beim Aufruf angegeben, interaktiv
% abgefragt. fuer die folgenden parameter werden dann Standardwerte eingesetzt.
%  Sk_text : Text fuer die Farbskala
%            frher konnte, falls flat=2 (isolinien), hier auch die Linienart
%              angegeben werden. nicht mehr noetig, da per user
%              interface gesetzt werden kann
%              
%  over    : overplot und Auswahl des Parameters
%           <=0 neues fenster
%           >=1 zeichne ueber das aktuelle Fenster
%           Der Absolutwert bestimmt, was gezeichnet wird:
%           0,1 gegriddete Variable
%           2   Fehlerfeld (erklaerte Varianz)
%           3   Optimale Ordnung (falls diese bestimmt wurde), sonst Anzahl
%               der Daten, die in der Berechnung der einzelnen Punkte eingeflossen sind.
%           4   Das Feld wird mit griddata(linear) aus den Eingabedaten berechnet
%           5   Das Feld wird mit griddata(cubic) aus den Eingabedaten berechnet
%           Zehner=1, heisst zeichnen einer Variable mit allen axen, etc.
%                     (nur verwendet bei over>0, da ansonsten immer achsen,etc. gezeichnet
%                     werden
%           Hunderter=1, heisst zeichne auf jeden Fall (soweit in der Eingabe vorhanden)
%                        die Positionen der Datenpunkte
%           Hunderter=2, heist zeichne auf keinen Fall die Datenpunkte
%  Bodenfarbe: Doppelbedeutung
%           A) String oder Vektor mit 3 elementen 
%              Farbe des Bodens beim malen von Schnitten mit Bodentopographie
%           B) Vektor mit 1 oder 2 Elementen
%              Es wird nicht der Boden sondern die Topographie (d.h. Karte) gemalt
%              1 Element: Topographie groesser als Bodenfarbe wird schwarz
%                         gemalt
%              2 Elemente: T.> Bodenfarbe(1) in grau; 
%                          T.> Bodenfarbe(2) in schwarz;
% AUSGABE
% bei flat=2
% Clin= handles der Labels; Hlin=handles der linien
%
% geschrieben von J.Holfort
% letzte Version: 05.09.2003 M.Kreus

% Bentzt Unterroutinen: netcdf-Toolbox
% NOCH ZU TUN:
% 1) bei return Zeilen muss ein geoeffneter netcdf-File geschlossen werden
% 2) man knnte der function evtl. einen besseren Namen geben, z.b.
%    function [Clin,Hlin]=SBsub_contourplot(data,isol,flat,Sk_text,over,Bodenfarbe,varargin)
%
global INTERAKTIV1
if isempty(INTERAKTIV1);
    interaktiv=1;
else
    interaktiv=INTERAKTIV1;
end
%interaktiv=1;
VAyaxis=[];
ii=1;
while ii<=length(varargin)
    T=varargin{ii}; ii=ii+1;
    if ~ischar(T); error('in variable argument list'); end
    if strcmpi(T,'no-inter')
        interaktiv=0;
    elseif strcmpi(T,'non-inter')
        interaktiv=-1;
    elseif strcmpi(T,'yaxis')
        T=varargin{ii}; ii=ii+1;
	if ischar(T)
	  if strcmpi(T,'fit')
	    VAyaxis=-1;
	  else
	    error('vararg yaxis unknown text')
	  end
	elseif length(T)==2
	  VAyaxis=T;
	else
	  error('vararg yaxis wrong parameter')
	end
    else
        error('unknown variable argument')
    end
end

T_isolin=[]; F_text=[1 1 1];
if exist('over')~=1 | isempty(over) ; over=0; end
Maleaxis=1;
overZ=mod(fix(abs(over)/10),10);
if overZ==1; over=over-10*sign(over); elseif over>0; Maleaxis=0; end
overH=mod(fix(abs(over)/100),10);
if overH>0; over=over-overH*100*sign(over); end

if exist('Bodenfarbe')~=1 ; Bodenfarbe='w'; end
if isempty(Bodenfarbe); Bodenfarbe=-1; end
TOPO=0;
if Bodenfarbe==-1; TOPO=0; elseif ~isstr(Bodenfarbe) & size(Bodenfarbe)~=3; TOPO=1; end

%-------------------- Input-File-Namen festlegen ----------------
% ................... Daten-File ................................
if exist('datei')==1;
    if isstr(datei)
        f=netcdf(datei,'read');
    elseif isstruct(datei)
        f=datei;
    elseif iscell(datei)
        if length(datei)~=3; error('Cell als Eingabe muss 3 Werte X,Y,Grid haben'); end
        f.X=datei{1};
        f.Y=datei{2};
        f.Grid=datei{3};
    else
        f.Grid=datei;
        [n,m]=size(datei);
        f.Y=[1:n];
        f.X=[1:m];
    end
else
    fprintf(' Netcdf-Grid Datei von Mk4insp \n'); f=netcdf('read');
    datei=name(f);
end
if isempty(f);  fprintf('Datei nicht vorhanden\n'); return; end

if isstr(datei)            % eine netcdf-Datei einlesen  
    xxx=f{'X'}(:); yyy=f{'Y'}(:); 
    if abs(over)<=1
        InsArr=f{'Grid'}(:); Rdef=f{'Grid'}.missing_value(:); ISOLIN=f{'Z'}(:)';
        if exist('Sk_text')~=1 ; Sk_text=f{'Z'}.Long_name(:); end
    elseif abs(over)==2
        InsArr=f{'Error'}(:); Rdef=f{'Error'}.missing_value(:); ISOLIN=[0:10:100]';
        if exist('Sk_text')~=1 ; Sk_text='erklaerte Varianz'; end
    elseif abs(over)==3
        InsArr=f{'OptOrd'}(:); Rdef=f{'OptOrd'}.missing_value(:); ISOLIN=[0:1:10]';
        if exist('Sk_text')~=1 ; Sk_text='Opt. Ordnung'; end
    elseif abs(over)==4 |  abs(over)==5
        d=f{'Data'}(:);
        if isempty(d);  
            fprintf(['Keine Daten in MK4INSP Datei gefunden, muessen bei over=4/5 aber vorhanden sein \n']); 
            return; 
        end
        if abs(over)==4 
            InsArr= griddata(d(1,:),d(2,:),d(3,:),xxx,yyy','linear');
        else	
            InsArr= griddata(d(1,:),d(2,:),d(3,:),xxx,yyy','cubic');
        end
        Rdef=-1e32; ISOLIN(:,1)=f{'Z'}(:);
        if exist('Sk_text')~=1 ; Sk_text=f{'Z'}.Long_name(:); end
    else
        fprintf('Parameter over muss zwischen -4 und 4 liegen\n')
        return
    end
    if isempty(InsArr);  
        fprintf(['Keine Variable Grid gefunden, keine MK4INSP Datei! \n']); return; 
    end
    TITEL=f{'Grid'}.Long_name(:); 
    X_LABEL=f{'X'}.Long_name(:); 
    Y_LABEL=f{'Y'}.Long_name(:);
    % an sich sollte hier noch auf Anwesenheit von xxx,yyy,ISOLIN und Rdef geprueft werden.
    ii=find(InsArr==Rdef); InsArr(ii)=NaN; clear ii;  % DUMMIES Behandlung 
else
    InsArr=f.Grid; ISOLIN=[];
    xxx=f.X; yyy=f.Y;
    TITEL='Titel'; 
    X_LABEL='X'; 
    Y_LABEL='Y';
    if exist('Sk_text')~=1 ; Sk_text='Z'; end
end
if isnan(min(min(InsArr))); error('Im Grid sind nur Fehlwerte!!'); end
if length(VAyaxis)==1
  dumy=find(~isnan(min(InsArr')));
  VAyaxis=[f.Y(min(dumy)) f.Y(max(dumy))];
end

if exist('Rdef')~=2; Rdef=-1e32; end
if isempty(Rdef);  Rdef=-1e32; end

%------------------------ SHADING Art Bestimmen ------------
lint=-1;
if exist('flat') & ~isempty(flat);
    lint=flat;
else
    xy=menu('Kontourart:',...
        'pcolor Flat ','pcolor Interpoliert ',...
        'Contourf, gefuelled','Contour, nur Linien ',...
        'Counturf, nur gefuellt','meshc (experimental');
    lint=xy-2;
    clear xy
end
if lint >4; fprintf('Falsche Konturierungsart %5i\n',lint); return; end

%.............. Isolinien und Farbskala bestimmen
if exist('isol')==1 & ~isempty(isol);
    [m,n]=size(isol);  
    if n<m; isol=isol'; [m,n]=size(isol); end
    if n==1;
        isol=[isol;isol];  % nachsehen ob richtig!!!!! oder isol=[isol isol]??
    end
    ISOLIN=isol(1,:);
    %ISOLIN(:,1)=isol(1,:); 4/2004 da Fehler, siehe voriges
else
    n=length(ISOLIN); 
    if n<2 | n>40
        ISOLIN=achsteil(min(min(InsArr)),max(max(InsArr)),20)'; 
        n=length(ISOLIN); 
    end
    m=1;
end
FARBEN=jet(n);
LINIEN=[ones(n,1) ones(n,1)*3];
if m==4;
    FARBEN=isol(2:4,:)';
elseif m==3;
    LINIEN=isol(2:3,:)';
    ill=LINIEN<=0; LINIEN(ill)=2;  % Mindestlinienstaerke=1
end
% an FARBEN noch Linienart fr contour-plot anhngen
FARBEN(:,4)=ones;
if lint==3, FARBEN(:,4)=ones*5;end %=keine Linien

axis_c=([min(ISOLIN) max(ISOLIN)]);

% --------------- Zeichnen je nach gewuenschter art ---------------------------------
if over<=0 ; 
    IFF=figure; 
    if isstr(datei); set(IFF,'NumberTitle','off');
        [Dpath,Dname] = fileparts(datei); set(IFF,'Name',Dname);
    end
else
    hold on
end
if Maleaxis==1; caxis(axis_c); end

% -------- falls erwnscht Topographie zeichnen
Achsenbereich=([min(xxx) max(xxx) min(yyy) max(yyy)]);

% -------- falls erwuenscht, luecken auffuellen
%i=input('Datenluecken auffuellen?');
i=-12;
if i==-1;
    [m n]=size(InsArr)
    for i=1:m
        ii=~isnan(InsArr(i,:));
        if sum(ii)>2;
            InsArr(i,:)=interp1(xxx(ii),InsArr(i,ii)',xxx');
        end
    end
end
for j=1:i; InsArr=arrfill(InsArr); end

if over>0;
    [ISOLIN,LINIEN,Quit,T_isolin,F_text]=ISO_ui(ISOLIN,LINIEN,F_text,interaktiv);
end
Quit=0;
while Quit==0;
    
    if lint<0;     % ------------------------------------------------------------ pcolor flat   
        % ..................... Matrix fuer FLAT vergroessern ...............
        xalt=xxx; yalt=yyy; InsArralt=InsArr;
        [m n]=size(InsArr); 
        %InsArr(m+1,:)=ones(1,n)*(Rdef); InsArr(:,n+1)=ones(m+1,1)*(Rdef);
        InsArr(m+1,:)=InsArr(m,:); InsArr(:,n+1)=InsArr(:,n);
        % ................... Achsen fuer FLAT vergroessern & verschieben ......
	    xxx(end+1)=xxx(end)+(xxx(end)-xxx(end-1));
	    dd=diff(xxx); dd(2:end+1)=dd; xxx=xxx-dd/2;
	    yyy(end+1)=yyy(end)+(yyy(end)-yyy(end-1));
	    dd=diff(yyy); dd(2:end+1)=dd; yyy=yyy-dd/2;
	    clear dd
        pcolor(xxx,yyy,InsArr);  shading('flat')
        axis_c=([min(ISOLIN) max(ISOLIN)]);
        colormap(jet(length(ISOLIN)));
        if Maleaxis==1; caxis(axis_c); end
        Achsenbereich=([min(xxx) max(xxx) min(yyy) max(yyy)]);
        xxx=xalt; yyy=yalt; InsArr=InsArralt; clear xalt yalt InsArralt
    elseif lint==0;    % ------------------------------------------------- pcolor interpoliert
        pcolor(xxx,yyy,InsArr);  shading('interp')
        axis_c=([min(ISOLIN) max(ISOLIN)]);
        if Maleaxis==1; caxis(axis_c); end
    elseif lint==4;    % ------------------------------------------------- meshc experimental
	[H]=meshc(xxx,yyy,InsArr);  shading('interp')
        axis_c=([min(ISOLIN) max(ISOLIN)]);
        if Maleaxis==1; caxis(axis_c); end
    elseif lint==1 | lint==3 ;    % ------------------ gefuelled,gefuelled+isolienen, contourf
        ii=0; ij=0; ISO_color=[];
        for i=1:length(ISOLIN)            
            if sum(FARBEN(i,1:3))~=3
                ii=ii+1; ISO_color(ii,1:4)=[ISOLIN(i) FARBEN(i,1:3)];
            end  
            if FARBEN(i,4)~=5
                ij=ij+1; ISO_line(ij,1:2)=[ISOLIN(i) FARBEN(i,4)];
            end
        end
        clf;
        [C,H,CF] =  contourf(xxx,yyy,InsArr,[ISO_color(:,1)]); 
        % if lint==3; shading('flat'), end     %wird jetzt anders gefiltert:
        if sum(FARBEN(:,4)==FARBEN(1,4))~=length(FARBEN) | lint==3, shading('flat'); end
        % l,lm muss benutzt werden da contourf die unterste CDATA
        % nicht mit Wert von ISOLIN sondern mit Minimum von A belegt.
        lm=min(min(InsArr)); l=find(ISOLIN<lm);
        if isempty(l); l=0; else; [k,z]=max(ISOLIN(l)); l=l(z); end
        for h=1:length(ISOLIN)
            if h==l; k=findobj(H,'CDATA',lm); 
            else; k=findobj(H,'CDATA',ISOLIN(h));
            end
            for i=k, set(i,'facecol',FARBEN(h,1:3)');  end
        end
        
        % die gewnschten ISOlinien drber legen
        if sum(FARBEN(:,4)==FARBEN(1,4))~=length(FARBEN)
            %ISO_line=[ISOLIN(FARBEN(:,4)~=5)];
            hold on; [C,H]=contour(xxx,yyy,InsArr,ISO_line(:,1),'k-');
            for h=1:length(ISO_line(:,1))
                k=findobj(H,'UserData',ISO_line(h,1)); 
                switch ISO_line(h,2)
                    case 2,     tt='--';  %dashed
                    case 3,     tt=':';   %dotted
                    case 4,     tt='-.';  %dash-dot
                    otherwise   tt='-';   %solid
                end
                if ~isempty(k),  set(k,'linestyle',tt);    end    
            end
        end
        
    elseif lint==2 ;       % -----------------------------------------------------SW Isolinien
        [C,H]=contour(xxx,yyy,InsArr,[ISOLIN],'k-');
        LineWidth=[0 0.5 1 1.5 2 2.5 3 3.5 4];
        for h=1:length(ISOLIN)
            k=findobj(H,'UserData',ISOLIN(h)); 
            switch LINIEN(h,1)
                case 2,     tt='--';  %dashed
                case 3,     tt=':';   %dotted
                case 4,     tt='-.';  %dash-dot
                otherwise   tt='-';   %solid
            end
            if ~isempty(k); 
                if LINIEN(h,1)==5, LINIEN(h,1)=1; end %default Linienart!
                if LINIEN(h,2)==1, LINIEN(h,2)=3; end %default Linienstrke!
                set(k,'linestyle',tt,'linewidth',LineWidth(LINIEN(h,2))); 
            end    
        end
    end
    
    if TOPO==1;
        hold on
        %if exist('TOPOH')~=1
            [TOPOH]=topoplot(Achsenbereich,[Bodenfarbe 15000],5,2);
            %end
        k=findobj(TOPOH,'CDATA',Bodenfarbe(1));
        for i=k; set(i,'EraseMode','xor');end;
        for i=k; set(i,'facecol',[0.5 0.5 0.5]);end;
        if length(Bodenfarbe)>1;
            k=findobj(TOPOH,'CDATA',Bodenfarbe(2)); 
            for i=k; set(i,'EraseMode','xor');end;
            for i=k; set(i,'facecol',[0 0 0]);end;
        end
        hold on
    end
    if ~isempty(VAyaxis); dumy=axis;  dumy(3:4)=VAyaxis; axis(dumy); end
    if lint<=0 | over>0;
        Quit=1;
    elseif lint==4
        Quit=1
    elseif lint==1 | lint==3 ;    % ------------------ farbige flchen
        [ISOLIN,FARBEN,Quit,T_isolin,F_text]=ISO_ui(ISOLIN,FARBEN,F_text,interaktiv);
        %FARBEN,
    else                          % ------------------ isolinien
        [ISOLIN,LINIEN,Quit,T_isolin,F_text]=ISO_ui(ISOLIN,LINIEN,F_text,interaktiv);
        %LINIEN,
    end
end

if lint~=4; axis(Achsenbereich); end
if ~isempty(VAyaxis); 
  dumy=axis; dumy(3:4)=VAyaxis; axis(dumy); 
end

%................ Bodentopographie .........................
if TOPO==1;   % Topographie wieder berlagern
    k=findobj(TOPOH,'CDATA',Bodenfarbe(1)); 
    for i=k; set(i,'EraseMode','background');end;
    for i=k; set(i,'facecol',[0.5 0.5 0.5]);end;
    if length(Bodenfarbe)>1;
        k=findobj(TOPOH,'CDATA',Bodenfarbe(2)); 
        for i=k; set(i,'EraseMode','background');end;
        for i=k; set(i,'facecol',[0 0 0]);end;
    end
else
    if ~isstr(Bodenfarbe) & size(Bodenfarbe)==1; werte=[];
    elseif isstr(datei);       werte=f{'Boden'}(:); 
    elseif isfield(f,'Boden'); werte=f.Boden; 
    else                   werte=[]; end
    if ~isempty(werte)
        if lint~=4; axis('ij'); end   % Dies dreht das Bild mit 0m nach oben
	A=axis;
        hold on
        if length(werte)<30   % bei weniger als 30 Stationen wird die
            % position am plot oben markiert
            LL=plot(werte(1,:),A(3),'dk','markersize',10);
	    if lint==4; for kk=LL; set(LL,'ZData',A(5)); end; end
        end
        n=length(yyy); m=size(werte,2);
        werte=[werte werte(:,m) werte(:,1) werte(:,1)];
        a1=werte(2,:); a2=yyy';
        werte(2,m+1)=max([werte(2,:),yyy']); 
        werte(2,m+2)=max([werte(2,:),yyy']); 
        werte(2,m+3)=werte(2,1); 
        LL=fill(werte(1,:),werte(2,:),Bodenfarbe); %keyboard
	if lint==4; 
	  for kk=LL;
	    ZData=get(kk,'XData');
	    ZData=zeros(size(ZData))+A(5);
	    set(kk,'ZData',ZData); 
	  end
	end
        hold off
    end
end

if exist('C'); 
    if interaktiv==1;
        cc=clabel(C,'manual');
    elseif interaktiv==0; 
        cc=clabel(C);
    end
    if exist('cc')==1
    for h=1:min([length(ISOLIN) length(T_isolin)])
        k=findobj(cc,'UserData',ISOLIN(h));
        %    if length(k)>0; set(k,'String',T_isolin(h)'); end    
        set(k,'String',T_isolin(h));    
    end  
    end   
    % ob der naechste Block gebraucht wird?
    %if TOPO==1;   % Topographie wieder berlagern
    %    k=findobj(TOPOH,'CDATA',Bodenfarbe(1)); 
    %    for i=k; set(i,'EraseMode','background');end;
    %    for i=k; set(i,'facecol',[0.5 0.5 0.5]);end;
    %    if length(Bodenfarbe)>1; 
    %        k=findobj(TOPOH,'CDATA',Bodenfarbe(2)); 
    %        for i=k; set(i,'EraseMode','background');end;
    %        for i=k; set(i,'facecol',[0 0 0]);end;
    %    end
    %end
end

if nargout>0; 
    if exist('C');Clin=cc; else; Clin=[]; end; 
end
if nargout>1;  
    if exist('H') Hlin=H; else; Hlin=[]; end; 
end

if Maleaxis==0 & isstr(datei); close(f); return; end

if exist('cc') & lint~=2; 
    set(cc,'color',F_text);     
    k=findobj(cc,'Type','line');  set(k,'Linestyle','none');
end 

%------------------ Farb-Skala -------------------------------------------------
if lint<2 | lint==3
    a1=gca;
    set(a1,'position',[0.13 0.13 0.7 0.75])	% Verschiebung des Hauptbildes
    axis_c=([min(ISOLIN) max(ISOLIN)]);
    s=linspace(min(min(axis_c)), max(max(axis_c)))';
    r=[s s]; hs2=axes('position',[0.93 0.13 .03 .75]);
    if lint<1;
        pcolor((1:2),s,r), shading flat
        set(hs2,'xtick',[]); ylabel(Sk_text)
        caxis(axis_c);
    else
        [cs,hs]=contourf((1:2),s,r,[ISO_color(:,1)]);
        if sum(FARBEN(:,4)==FARBEN(1,4))==length(FARBEN) & lint==3; shading('flat'), end         
        for h=1:length(ISO_color(:,1))
            k=findobj(hs,'CDATA',ISO_color(h,1));
            for i=k; set(i,'facecol',ISO_color(h,2:4)');end    
        end
        set(hs2,'xtick',[]); ylabel(Sk_text)
    end
    axes(a1); % zurueckschalten auf Hauptbild
end

%-----------------------   Beschriftung --------------------------
%set(TOPOH,'tag','TOPOH')
%saveas(gcf, 'output', 'fig')
%return
xlabel(X_LABEL); ylabel(Y_LABEL); title(TITEL); hold off


%................ Datenpunkte .........................
if isstr(datei);          werte=f{'Data'}(:); 
elseif isfield(f,'Data'); werte=f.Data; 
else                      werte=[]; end
if ~isempty(werte) & ( overH==1 | abs(over)<4 | length(werte)<500 ) ...
        & overH~=2
    hold on
    plot(werte(1,:),werte(2,:),'k+') 
    hold off
end


if isstr(datei); close(f), end

%................ Aussehen des plots
set(gca,'tickdir','out'); set(gca,'Layer','top')  

%% keine Ahnung warum das hier hin muss, aber sonst funktionierts nicht
if TOPO==1;
    hold on
    if exist('TOPOH')~=1
        [TOPOH]=topoplot(Achsenbereich,[Bodenfarbe 15000],5,2);
    end
    %    k=findobj(TOPOH,'CDATA',Bodenfarbe(1));
    %    for i=k; set(i,'EraseMode','xor');end;
    %    for i=k; set(i,'facecol',[0.5 0.5 0.5]);end;
    %    if length(Bodenfarbe)>1;
    %        k=findobj(TOPOH,'CDATA',Bodenfarbe(2)); 
    %        for i=k; set(i,'EraseMode','xor');end;
    %        for i=k; set(i,'facecol',[0 0 0]);end;
    %    end
    %    hold on
    k=findobj(TOPOH,'CDATA',Bodenfarbe(1)); 
    for i=k; set(i,'EraseMode','background');end;
    for i=k; set(i,'facecol',[0.5 0.5 0.5]);end;
    if length(Bodenfarbe)>1;
        k=findobj(TOPOH,'CDATA',Bodenfarbe(2)); 
        for i=k; set(i,'EraseMode','background');end;
        for i=k; set(i,'facecol',[0 0 0]);end;
        pause(.1)        
        for i=k; set(i,'facealpha',[0]);end; 
    end
end
%disp('stepout mk4_ins');
