% UI um Dateinamen und lat,lon,wtiefe darzustellen und
% gegebenfalls korregieren
% Als vorhanden werden vorausgesetzt:
% IP
% D.name,D.lat,D.lon,D.wtiefe
%
% wichtiges Unterprogram von sbplot%
% berarbeitet: 16.07.2003 M.Kreus

% Figure-Gre festlegen
ScrSiz=get(0,'ScreenSize');
Mx=450; My=20*IP+60;
FigPos=[ceil(ScrSiz(3)/2)-ceil(Mx/2) ceil(ScrSiz(4)/2)-ceil(My/2)];
px=2; GRAU=[0.7 0.7 0.7];

ui0 = figure('Color',GRAU,'Position',[FigPos Mx My], ...
   'Name','Datei und Dateninformation', ...   
   'NumberTitle', 'off', 'Resize', 'on',...
   'HandleVisibility','on',...
   'Menubar','none');
uiF=uicontrol('Style','frame','Position',[1 My-21 Mx 21],...
    'foregroundcolor','w');
uiT=uicontrol('Style','text','Position',[px My-20 298 18],...
   'String','Dateiname','FontWeight','bold');%,'FontSize',10);
uiT=uicontrol('Style','text','Position',[px+300 My-20 48 18],...
   'String','Lat.','FontWeight','bold');%,'FontSize',10);
uiT=uicontrol('Style','text','Position',[px+350 My-20 48 18],...
   'String','Lon.','FontWeight','bold');%,'FontSize',10);
uiT=uicontrol('Style','text','Position',[px+400 My-20 48 18],...
   'String','Tiefe','FontWeight','bold');%,'FontSize',10);

for i=1:IP
   py=My-(i+1)*20;
   uiF=uicontrol('Style','frame','Position',[1 py-1 Mx 21],...
   'foregroundcolor','w');
uiNAME(i)=uicontrol('style','text','Position',[px py 298 18],...
    'string',D(i).name);%,'FontSize',10);
uiLAT(i)=uicontrol('style','edit','Position',[px+300 py 48 18],...
    'string',num2str(D(i).lat),'backgroundcolor',GRAU);
uiLON(i)=uicontrol('style','edit','Position',[px+350 py 48 18],...
    'string',num2str(D(i).lon),'backgroundcolor',GRAU);
uiWt(i)=uicontrol('style','edit','Position',[px+400 py 48 18],...
    'string',num2str(D(i).wtiefe),'backgroundcolor',GRAU);
end 
uiF=uicontrol('Style','frame','Position',[1 My-(IP+2)*20+1 Mx 19],...
   'foregroundcolor','w');
uiT=uicontrol('style','text','Position',[px 1 300 19],...
   'string','Angaben gegebenenfalls korregieren. Weiter mit =>');
uiENDE=uicontrol(ui0,'style','pushbutton',...
   'position',[px+300 1 150 19],...
   'String','ENDE',...
   'callback','uiresume(ui0);');

uiFehler=1;
while uiFehler~=0
   uiwait(ui0)
   fenster=gcf;
   if ui0==fenster
      u=get(0,'children');
      uiFehler=0;
      if sum(u==ui0)~=0
         uiFehler=0;
         for i=1:IP
            r=get(uiLAT(i),'String'); r=str2num(r);
            if length(r)~=1 | isnan(r)
               uiFehler=1; set(uiLAT(i),'backgroundcolor','r');
            else
               D(i).lat=r; set(uiLAT(i),'backgroundcolor',GRAU)
            end
            r=get(uiLON(i),'String'); r=str2num(r);
            if length(r)~=1
               uiFehler=1; set(uiLON(i),'backgroundcolor','r');
            else
               D(i).lon=r; set(uiLON(i),'backgroundcolor',GRAU)
            end
            r=get(uiWt(i),'String'); r=str2num(r);
            if length(r)~=1
               uiFehler=1; set(uiWt(i),'backgroundcolor','r');
            else
               D(i).wtiefe=r; set(uiWt(i),'backgroundcolor',GRAU)
            end
            
         end
         if uiFehler>0; set(uiT,'string','Bitte rote Felder korregieren',...
               'foregroundcolor','b'); end
      end
   else
      uiFehler=0;
   end
   
end
if ui0==fenster; close(ui0); end	
   
   
