function sb2cdf(DATEI,DATA,Header,Namen,time,lat,lon,wtiefe,varargin)
% sb2cdf(DATEI,DATA,Header,Namen,time,lat,lon,wtiefe,varargin)
% writes data as read in bye sberead (e.G. Seabird Data file) into an
% netcdf file
% Variable Arguments must come in pairs, the first gives the name of a
% global attribute, the second the value of this attribut
%
% Time can be given in different formats
% 6 values= day,month,year,hour,min,sec
% 4 values= day,month,year,hours
% 3 values= day,month,year
% 1 values= days as in matlab datenum,datevec
Zeit0=datenum(1940,1,1,0,0,0);

if length(time)==3, time=[time 0 0 0]; end
if length(time)==4;
 if time(4)>24; 
   warning('Hours in time more then 24!');
   hour=0; minute=0; sec=0;
 else 
   hour=floor(time(4)); 
   minute=mod(time(4)*60,60);
   sec=mod(minute*60,60); minute=floor(minute);
 end
 time=[time(1:3) hour minute sec]; 
end
if length(time)==6
   DAYS=datenum(time(3),time(2),time(1),time(4),time(5),time(6));
elseif length(time)==1
   DAYS=time;
   time=datevec(DAYS);
else
   warning('wrong dimension for time, must be 1,3 or 6')
end

nc = netcdf(DATEI, 'clobber');              % Create NetCDF file.
if isempty(nc); error('could not open output file'); end

nc.Water_Depth    =wtiefe;                    % Wassertiefe

nc.Date           =ncint(time);               % Datum im format tag,monat,jahr,stunde,minute,sekunde
nc.Latitude       =lat;                 % Breite Nord in dezimalgrad
nc.Longitude      =lon;                 % Länge Ost in dezimalgrad
%nc.DATA_ORIGIN    =' ';           % woher kommen die Daten
nc.missing_value  = -9999.;                  % falls Fehlwerte mit


q1=size(Header);
if q1(2)>0
  nc('Text')      = q1(2);
  nc('Comments')  = q1(1);
  nc{'Comment'}   = ncchar({'Comments','Text'});
  nc{'Comment'}(:,:)=Header;
end
  
nc('latitude')  = 1;
nc('longitude') = 1;
q1=size(DATA);
Namen=cellstr(Namen);
% Namen linksbuendig schreiben und Units abtrennen
for ii=1:q1(2)
    jj=ismember(Namen{ii},',.#');
    Namen{ii}(jj)=' ';
    jj=isspace(Namen{ii});
    if sum(jj)>0 & jj(1)==1;
        kk=find(~jj);
        Namen{ii}=Namen{ii}(kk(1):end);
    end
    Namen{ii}=deblank(Namen{ii});
    jj=find(isspace(Namen{ii}));
    if ~isempty(jj)
        UNITS{ii}=Namen{ii}(jj(1)+1:end);
        Namen{ii}=Namen{ii}(1:jj(1)-1);
    else
        UNITS{ii}=' ';
    end

    % TEMP in T90 aendern, falls in units T90 vorkommt 
    if findstr(Namen{ii},'TEMP')==1
       if findstr(UNITS,'T90')>0
          Namen{ii}='T90'; UNITS='degC';
       end
    end    

    % doppelt vorkommende Namen veraendern
    for ij=1:ii-1
        if strcmp(Namen{ii},Namen{ij})
            Namen{ii}=[sprintf('%1.1i',ii) Namen{ii}];
        end
    end
end

% Art Bestimmen.
% hier gilt ART=1 ist zeitreihe; ART=4 ist Profil
ART=0; nTIME=0;
for ii=1:q1(2)
   if strfind(Namen{ii},'time')==1; ART=1; nTIME=ii; break; end
   if strfind(Namen{ii},'PRES')==1 & ART ~=1; ART=4; end
end
switch ART
case 0
  NART='PRES';nc('time')= 1;
  nc('time')= 1;
  nc{'time'}      = ncfloat('time');    
  nc{'time'}(:)   = DAYS-Zeit0;
case 1
  NART='time';
case 4
  NART='PRES';nc('time')= 1;
  nc('time')= 1;
  nc{'time'}      = ncfloat('time');    
  nc{'time'}(:)   = DAYS-Zeit0;
otherwise
  error('falsche, unbekannte ART');
end

nc(NART)= q1(1);
nc{'latitude'}  = ncfloat('latitude');
nc{'latitude'}(:)  = lat;         
nc{'longitude'} = ncfloat('longitude');
nc{'longitude'}(:) = lon;

if nargin>8;
    if mod(nargin,2)~=0;
        error('Wrong number of Variable Arguments, must come in pairs');
    end
    for ivv=1:2:nargin-8
        TT=varargin{ivv};
        if ~ischar(TT);
            error('First of a pair of variable Arguments must be a string');
        end
        eval(['nc.' TT '=varargin{', num2str(ivv+1) '};']);
    end
end

for ii=1:q1(2)
    %Zeit bei Zeitreihen einstellen
    if ii==nTIME
       if min(DATA(:,ii))>686657 & max(DATA(:,ii))<759706;
          % zeit liegt von den nummerm zwischen datetime(1880) und 2080
          DATA(:,ii)=DATA(:,ii)-Zeit0;
          UNITS{ii}='days since 1.1.1940';
       elseif min(DATA(:,ii))>2407716 & max(DATA(:,ii))<2480765;
          % zeit liegt von den nummerm zwischen julday(1880) und 2080
          DATA(:,ii)=DATA(:,ii)-julday(1,1,1940);  
          UNITS{ii}='days since 1.1.1940';
       end
    end

    if sum(~isnan(DATA(:,ii)))>0 
     nc{Namen{ii}}      = ncfloat(NART);
     nc{Namen{ii}}(:)   = DATA(:,ii);
     % naechste Zeile eingefugt, da ohne diese manchmal die
     % Daten falsch geschrieben wurden (z.B. Lance 2002,Station 26)
     % beziehungsweise zwischendurch Werte fehlten.
     %  Muss ein Fehler in der netcdf toolbox sein, trat be Stat.
     % 26 auch nur auf, falls variable input argumente benutzt wurden.
     dumy=nc{Namen{ii}}(:);  % 
     nc{Namen{ii}}.units= UNITS{ii};
    end 
end
nc = close(nc);                                      % Close the file.
