% sb_ui
% UI um Dateinamen einzulesen und gewnschte Darstellungsart bzw.
% andere Parameter zum Plotten auszuwhlen
% wichtiges Unterprogram von sbplot

% berarbeitet: 05.09.2003 M.Kreus

%disp('stepin sb_ui');
global pathname DISK NAME EXT PROF

if iscell(DISK),   FILELIST=DISK;   DISK=[]; else DISK=[]; end
if ~ischar(DISK)
    if isempty(pathname) | ~ischar(pathname)
        DISK='\data\'; 
    else
        DISK=pathname; 
    end
end

if exist('FILELIST')~=1; FILELIST={' ',' '}; end
if ~iscell(FILELIST);  FILELIST={' ',' '}; end
if isempty(DISK) | ~ischar(DISK),  DISK='\data\'; end
if isempty(NAME), NAME='DM03'; end
if isempty(EXT), EXT='.asc'; end
if isempty(PROF), PROF=1; end

if exist('plotart')~=1; plotart=2; end
if exist('Hievweg')~=1; Hievweg=1; end
if exist('Mitteln')~=1; Mitteln=0; end
if ischar(Mitteln); Mitteln=0; end
if exist('Fenster')~=1; Fenster=Mitteln; end
if exist('SW')~=1; SW=1; end
if exist('Obenweg')~=1; Obenweg=11; end
if exist('XVAR')~=1; XVAR=0; end

prompt='SBplot';
position=[130 130 600 400];
%'Color','y', ...
ui0 = figure('Name', prompt, ...
    'Position', position, ...
    'Color',[0.8 0.8 0.8],...
    'NumberTitle', 'off', ...
    'Resize', 'off',...
    'HandleVisibility','on',...
    'Menubar','none');

% Definition einer Achse um Abgrenzungslinien,etc zu zeichnen
axes('position',[0 0 1 1],'visible','off',...
    'Xlim',[0 600],'Xlimmode','manual',...
    'Ylim',[0 400],'Ylimmode','manual');

% CONTROLS ZUR DATEIANGABE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%        
uiDISK  =uicontrol(ui0,'style','edit','position',[30 340 200 20],...
    'Tag','disk','string',DISK,...
    'BackgroundColor','w');...
    uiT=uicontrol('Style','text','Position',[30 360 200 20],...
    'Tag','disk','String','Verzeichnissangabe',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);

uiNAME  =uicontrol(ui0,'style','edit','position',[240 340 100 20],...
    'Tag','name','string',NAME,...
    'BackgroundColor','w');...
    uiT=uicontrol('style','text','Position',[240 360 100 20],...
    'Tag','name','string','1 Namensteil',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);

uiEXT   =uicontrol(ui0,'style','edit','position',[360 340 100 20],...
    'Tag','ext','string',EXT,...
    'BackgroundColor','w');...
    uiT=uicontrol('style','text','Position',[360 360 100 20],...
    'Tag','ext','string','Extension',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);

uiPROF   =uicontrol(ui0,'style','edit','position',[30 290 430 20],...
    'Tag','prof','string',num2str(PROF),...
    'BackgroundColor','w');...
    uiT=uicontrol('style','text','Position',[30 310 170 20],...
    'Tag','prof','string','Dateinummern',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);...%,'HorizontalAlignment','left');
    uiT=uicontrol('Style','text','Position',[200 311 200 18],...
    'Tag','prof','String','( z.Bsp.: [10 12 14 16] oder [10:2:16] )',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',8,'HorizontalAlignment','left');

uiFILELIST   =uicontrol(ui0,'Style','edit','position',[30 290 430 90],...
    'Tag','Filelist','String',FILELIST,...
    'Min',1,'Max',100,...
    'BackgroundColor','w','Visible','off');

uiFswitch   =uicontrol(ui0,'Style','pushbutton','Position',[480 340 90 40],...
    'Tag','uif','String','Dateipfad',...
    'FontSize',10,...
    'CreateFcn','sb_ui_sub(2,1);',...
    'Callback','sb_ui_sub(2,1);');    

uiDateiMenu   =uicontrol(ui0,'Style','pushbutton','Position',[480 290 90 40],...
    'Tag','DateiMenu','String','Auswahl',...
    'FontSize',10,...
    'Callback','sb_ui_sub(3,1);');%,'Visible','off'); 

line([0 600],[280 280],'color','w');%[0.9 0 0.9])

% CONTROLS ZUR VERARBEITUNG %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%       
uihiev   =uicontrol('Style','checkbox','Position',[430 250 140 20],...
    'Tag','hiev','string',' Hievteile entfernen','Value',Hievweg,...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);...
    
uiobenweg   =uicontrol(ui0,'style','edit','position',[290 250 60 20],...
    'Tag','obenweg','string',num2str(Obenweg),...
    'BackgroundColor','w');...
    uiT=uicontrol('Style','text','Position',[30 250 260 20],...
    'String','Werte entfernen mit Druck kleiner als (db) :',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10,'HorizontalAlignment','left');

uimittel   =uicontrol(ui0,'Style','edit','position',[170 220 50 20],...
    'String',num2str(Mitteln),'Tag','mitteln',...
    'BackgroundColor','w');...
    uiT=uicontrol('Style','text','Position',[30 220 140 20],...
    'String','Mitteln auf db Abstand:',...
    'BackgroundColor',[0.8 0.8 0.8], 'FontSize',10,'HorizontalAlignment','left');

uifenster   =uicontrol(ui0,'Style','edit','Position',[435 220 50 20],...
    'String',num2str(Fenster),'Tag','fenster',...
    'BackgroundColor','w');...
    uiT=uicontrol('Style','text','Position',[250 220 180 20],...
    'String','Druckfenster beim Mitteln (db):',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10,'HorizontalAlignment','left');

line([0 600],[210 210],'color','w');%[0.9 0 0.9])

% CONTROLS ZUR PLOTAUSWAHL %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
uiart   =uicontrol('Style','popupmenu','Position',[30 180 100 20],...    
    'Tag','art','String',{'XYplot','Schnitt','Gitter','XYZPlot','Pos-Karte'},...
    'value',plotart,'callback','ss=sb_ui_sub;',...
    'FontSize',10,'BackgroundColor','w');

uiSW   =uicontrol('style','popupmenu','position',[130 180 200 20],...
    'Tag','SW','string',{'Farbig mit isolinien','Schwarz-Weiss','nur Farbe','anders'},'Value',SW,...
    'FontSize',10,'BackgroundColor','w');

uiSectX   =uicontrol(ui0,'style','popupmenu','Position',[30 130 300 20],...
    'Tag','SectX','String',{' Distanz',' Zeit',' Breite',' Lnge'},'value',XVAR+1,...
    'FontSize',10,'BackgroundColor','w');...
    uiT=uicontrol('Style','text','Position',[30 150 300 20],...
    'Tag','SectX','String',' Variable der X-Achse',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);%,'Visible','off');

PushX='[i,var]=sbvariable(-1);set(gco,''String'',var,''UserData'',i);';
if ~exist('textx'), iix=1; [iix,textx]=sbvariable(iix); end
uivarx=   uicontrol(ui0,'Style','pushbutton','Position',[30 130 300 20],...
    'Tag','varx','String',textx,'UserData',iix,...
    'Callback',PushX);...%'BackgroundColor','w',...    
    uiT=uicontrol('Style','text','Position',[30 150 300 20],...
    'Tag','varx','String',' Variable der X-Achse',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10);%,'Visible','off');

if ~exist('texty'), iiy=0; [iiy,texty]=sbvariable(iiy); end    
uivary=   uicontrol(ui0,'Style','pushbutton','Position',[30  80 300 20],...
    'Tag','vary','String',texty,'UserData',iiy,...
    'Callback',PushX);...
    uiT=uicontrol('style','text','Position',[30 100 300 20],...
    'Tag','vary','string',' Variable der Y-Achse',...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10); 

if plotart==4, stringZ=' Variable der Z-Achse'; 
else,  stringZ=' zu konturierender Parameter'; end

if ~exist('textz'), iiz=1; [iiz,textz]=sbvariable(iiz); end     
uivarz=   uicontrol(ui0,'style','pushbutton','position',[30 80 300 20],...
    'Tag','varz','String',textz,'UserData',iiz,...
    'Callback',PushX);...
    uiT=   uicontrol('Style','text','Position',[30 100 300 20],...
    'Tag','Tvarz','String',stringZ,...
    'BackgroundColor',[0.8 0.8 0.8],'FontSize',10); 

ss=sb_ui_sub(1,plotart); 

% CONTROL ZUR BEENDUNG %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
uiENDE=uicontrol(ui0,'Style','pushbutton','Position',[430 30 90 40],...
    'String','OK',...
    'Callback','sb_ui_exit(ui0,uiDISK,uiNAME,uiEXT,uiPROF,uiFILELIST,uiart);');

uiwait(ui0)


%------- Auswerten des User Interfaces----------------------------------

if gcf==ui0
    ii=get(uiDISK,'visible');
    if strcmp(ii,'on');
        R=get(uiDISK,'String'); 
        if ~isempty(deblank(R));   DISK=R; end
        R=get(uiNAME,'String'); 
        if ~isempty(deblank(R));   NAME=R; end
        R=get(uiEXT,'String'); 
        if ~isempty(deblank(R));   EXT=R; end
        R=get(uiPROF,'String'); 
        if ~isempty(deblank(R));   PROF=str2num(R); end
    else        
        DISK=get(uiFILELIST,'String');
        iprof=0;
        while iprof<length(DISK)
            if strcmp(char(DISK(iprof+1)),' ')==1
                DISK(iprof+1)=[];
            else
                iprof=iprof+1; 
            end
        end
        if iprof<1; error('sbplot, no input files given'); end
    end
    
    R=get(uiobenweg,'String'); 
    if ~isempty(deblank(R));   Obenweg=str2num(R); end
    
    plotart=get(uiart,'Value'); 
    SW=get(uiSW,'Value'); 
    Hievweg=get(uihiev,'Value'); 
    
    R=get(uiPROF,'String'); 
    if ~isempty(deblank(R));   PROF=str2num(R); end
    
    R=get(uimittel,'String'); 
    if ~isempty(deblank(R));   Mitteln=str2num(R); end
    %     if length(Mitteln)==1; Mitteln=[Mitteln Mitteln]; end
    %     if Mitteln(1)>0 & Mitteln(2)<=0; Mitteln(2)=Mitteln(1); end
    
    R=get(uifenster,'String'); 
    if ~isempty(deblank(R));   Fenster=str2num(R); end
    if Mitteln>0 & Fenster<0; Fenster=Mitteln; end
    
    
    XVAR=get(uiSectX,'value')-1;
    textx=get(uivarx,'String');
    iix=get(uivarx,'UserData');
    texty=get(uivary,'String');
    iiy=get(uivary,'UserData');
    if plotart==2; iiy=0; end; % bei Schnitte yvariable=PRES
    textz=get(uivarz,'String');
    iiz=get(uivarz,'UserData');
    
    close(ui0)
else
    error('Abbruch bei SBPLOT Auswahl, nicht mit ENDE abgeschlossen')
end
%disp('stepout sb_ui');
