function [lat,lon, Wtiefe] = sbepos(header)
% versucht aus den von dem Benutzer eingegebenen
% Headerzeilen die Breite (lat), Lnge (lon),
% und Wassertiefe zu dekodieren.
% Dazu mussen die entsprechenden Headerzeilen
% folgenden Aufbau haben: 
% zuerst ein festgelegte Bezeichnung (s.u.), 
% dann koennen Leerzeichen kommen, 
% dann ein Doppelpunkt (:) und 
% dann der eigentliche Wert. z.B.:
% Latitude  : 45N45.6
% Longitude : 30W45.6
% Waterdepth: 3600
% In den Positionen muss irgenwo eines von NnSS
% bzw. EeWw vorkommen.
% Bei einer Zahl ist grad, 2 Zahlen= Grad minute
% 3 Zahlen Grad,minute,sekunde
%
% Aenderungen:
% 26.3.2003: Bei Breite und Laenge aus 2 Zahlen wird gesehen, ob
%  exakt ein Minuseichen vorkommt. Wenn dann die Minuten positiv sind
%  werden diese auf negativ gesetzt.
%  So werden Angaben "-30 30" als -30.5 interpretiert anstatt als -29.5
%  was meistens mehr Sinn ergibt
% 26.3.2003 falls Tiefenstring mit num2str nicht dekodierbar, wird
%  jetzt alles ausser Zahlen entfernt und nochmals versucht. Dies umgeht
%  nicht moegliche Dekodierung bei Zusatzangaben (z.B. Einheiten wie in
%   DEPTH: 3000m
%% 26.3.2003 falls nichts gefunden wird nach Zahl gesucht
jj=size(header);
lat=NaN; lon=NaN; Wtiefe=NaN;
Twtiefe='Depth';  % Suchtext fr Wassertiefe
for ii=1:jj(1)
  s=header(ii,:);
  kk=findstr(s,Twtiefe);
  if isempty(kk) kk=findstr(upper(s),upper(Twtiefe)); end
  if ~isempty(kk)
     kk=findstr(s,':');
     if isempty(kk)
        kk=isletter(s);
        s(kk)=' ';
        warning('moeglicher Fehler bei Decodierung Wassertiefe')
     else     
        s=s(kk+1:jj(2));
     end
     kk=str2num(s);
     if isempty(kk);   % 26.3.2003 falls nichts gefunden wird nach Zahl gesucht
         kk=str2num(s(ismember(s,'0123456789')));
     end
     if isempty(kk)
         warning('keine Wassertiefe gefunden')
         Wtiefe=-9999;
     else         
         Wtiefe=kk(1);
     end
  end
  kk=findstr(s,'Latitude'); 
  if ~isempty(kk)
     kk=findstr(s,':');
     s=s(kk+1:jj(2));
     lat=1;
     kk=findstr(s,'S');
     if isempty(kk); kk=findstr(s,'s'); end
     if ~isempty(kk);
        lat=-1;
        s(kk)=' ';
     else
        kk=findstr(s,'N');
        if isempty(kk); kk=findstr(s,'n'); end
        if isempty(kk);
           fprintf('Positionsstring: %s\n',s); 
           warning('kein N/S gefunden N wird angenommen')
           kk=isletter(s);
        end
        s(kk)=' ';
     end
     kk=str2num(s);
     if length(kk)<1
        lat=0;
        warning('Keine Latitude gefunden, gesetzt auf 0')
     elseif length(kk)==1
        lat=lat*kk;
     elseif length(kk)==2
        if length(findstr(s,'-'))==1 & kk(2)>0; kk(2)=-kk(2); end
        lat=lat*( kk(1)+kk(2)/60);
     elseif length(kk)==3
        lat=lat* ( kk(1)+kk(2)/60 +kk(3)/3600);
     else
        lat=lat* ( kk(1)+kk(2)/60 +kk(3)/3600);
        warning('latitude mehr als 3 Zahlen')
     end   
  end
  kk=findstr(s,'Longitude'); 
  if ~isempty(kk)
     kk=findstr(s,':');
     s=s(kk+1:jj(2));
     lon=1;
     kk=findstr(s,'W');
     if isempty(kk); kk=findstr(s,'w'); end
     if ~isempty(kk);
        lon=-1;
        s(kk)=' ';
     else
        kk=findstr(s,'E');
        if isempty(kk); kk=findstr(s,'e'); end
        if isempty(kk); kk=findstr(s,'O'); end
        if isempty(kk); kk=findstr(s,'o'); end
        if isempty(kk);
           fprintf('Positionsstring: %s\n',s); 
           warning('kein W/E/O gefunden')
           kk=isletter(s);
        end
        s(kk)=' ';
     end
     kk=str2num(s);
     if length(kk)<1
        lon=0;
        warning('Keine Longitude gefunden, gesetzt auf 0')
     elseif length(kk)==1
        lon=lon*kk;
     elseif length(kk)==2
        if length(findstr(s,'-'))==1 & kk(2)>0; kk(2)=-kk(2); end
        lon=lon*( kk(1)+kk(2)/60);
     elseif length(kk)==3
        lon=lon* ( kk(1)+kk(2)/60 +kk(3)/3600);
     else
        lon=lon* ( kk(1)+kk(2)/60 +kk(3)/3600);
        warning('longitude mehr als 3 Zahlen')
     end   
  end
end

