function [DATA,Header,Namen,time,lat,lon,wtiefe]=sberead(Datei,nzyk)
% NEU 21.11.2001
% function [DATA,Header,Namen,time,lat,lon,wtiefe]=sberead(Datei,nzyk)
% liest eine Datei in Seabird Ascii/binaer format
% bei nzyk==0 wird nur der Header gelesen
% bei nzyk==-1 werden in Ausgabe Header alle Kopfzeilen
% geschrieben (um nachher binaer wieder wegzuschreiben, dabei
% musssen aber folgende Aendrungen, de den Header mit betreffen
% selber geaendert werden).
% Ausgabe sind die vom Benutzer eingegebenen
% Informationen in der Variablen Header
% Die namen der Variablen in Namen
% und in DATA dann die Daten.
% Eingabe ist der Name der Datei, z.B.
% Datei='D:\m454\save\m454512.asc';
if nargin<1; Datei=[]; end
if isempty(Datei); 
    [Datei pfad]=uigetfile('*.*','Choose an Seabird CNV-Input file');
    Datei=[pfad Datei];
end
if isempty(Datei); error('No inputfile given'); end
if nargin<2; nzyk=1; end
def=-9.99E-29; time=0;
asc_bin=1;
Header=[]; HeaderU=''; Namen='';time=[];lat=[];lon=[];wtiefe=[];
[PATH,NAME,EXT,VER] = fileparts(Datei);

if (strcmp(upper(EXT),'.CDF') | strcmp(upper(EXT),'.NC')) & ...
   (exist(fullfile(PATH,[NAME EXT,VER]))==2)
    f=netcdf(fullfile(PATH,[NAME EXT,VER]),'r');
    lat=f.Latitude(:);
    lon=f.Longitude(:);
    wtiefe=f.Water_Depth(:);
    if isempty(wtiefe); wtiefe=f.Water_depth(:); end
    time=f.Date(:);
    HeaderU=num2str(fix(time));
    HeaderU=strvcat(HeaderU,['Latitude:' sprintf('%f',lat(1))]);
    HeaderU=strvcat(HeaderU,['Longitude:' sprintf('%f',lon(1))]);
    HeaderU=strvcat(HeaderU,['Wassertiefe:' sprintf('%10.1f',wtiefe)]);
    def=f.missing_value(:);
    if isempty(def); def=-9999.; end
    NamenX=ncnames(var(f));
    NamenD=ncnames(dim(f));    % search for the right dimension
    % or starting with pres or with time, 
    % if not found or equals 1 take the largest
    ipres=find(strncmp('PRES',upper(NamenD),4)); jjpres=0;
    ipres=ipres(1);
    if ipres>0;
      jjpres=length(f(NamenD{ipres}));
    else
      ipres=strncmp('TIME',upper(NamenD),4);
      if ipres>0;
         jjpres=length(f(NamenD{ipres}));
      end
    end
    if jjpres<=1;
      for ii=1:length(NamenD)
	    jjpres=max(jjpres,length(f(NamenD{ii})));
      end
    end
    % if still 1 see if we find a variable startin with PRES
    if jjpres<=1;
       ipres=strncmp('PRES',upper(NamenX),4);
       if ipres>0; jjpres=length(f{char(NamenX(ipres))}(:)); end
    end
    % read in the data
    DATA=[]; 
    if nzyk>0
        for ii=1:length(NamenX)
            rr=f{char(NamenX(ii))}(:);
            if length(rr)==jjpres; Namen=strvcat(Namen,char(NamenX(ii))); DATA=[DATA;rr']; end
        end
        DATA=DATA';
        ii=DATA==def;
        if sum(sum(ii))>0; DATA(ii)=NaN; end
    end
    Header=HeaderU;
    close(f)
elseif exist(fullfile(PATH,[NAME '.mat',VER]))==2
    load(fullfile(PATH,[NAME '.mat',VER]))
    if nzyk<1
        DATA=[];
    end    
else    
    [fid,fmessage]=fopen(Datei,'r');
    asc_bin=0; % erstmal wird ein ascii Fileformat angenommen
    if fid== -1; 
      DATA=[];
      warning(['File open error (exists?,permission?) for file:' Datei]);
      warning(['-Error message:' fmessage]);
      return; 
    end
    jheader=0;
    while 1
        % Als Headerzeile zhlen nur Zeilen mit mindestens 3 Zeichen
        % (damit berliest man auch CR LF zeilen auf UNIX)
        s=' ';
        while length(s)<4; 
	  s=fgetl(fid); 
	  if ~ischar(s), 
	    DATA=[]; 
	    warning(['unexpected End of File:' Datei]);
	    return
	  end
	end
        Header=strvcat(Header,s); 
        jheader=jheader+1;
        if s(1:1)=='*'
            if s(1:2)=='**'
                HeaderU=strvcat(HeaderU,deblank(s(3:length(s))));
            end
            ii=findstr(s,'* System UpLoad Time'); if isempty(ii); ii=100; end
            if length(s)>20 & ii<5
                t1=deblank(s(23:length(s)));
                time=Zeitdecode(t1);
                HeaderU=strvcat(HeaderU,t1);
            end
            ii=findstr(s,'*END*'); if ~isempty(ii);
                if ii(1)==1; istop=1; break; end; end
        elseif s(1:1)=='#'
            if strncmp(s,'# name',6)
                ii=findstr(s,':');
                Namen=strvcat(Namen,deblank(s(ii(1)+1:length(s))));
            end
            if strncmp(s,'# bad_flag',10)
                ii=findstr(s,'=');
                def=str2num(s(ii(1)+1:length(s)));
            end
            if strncmp(s,'# nquan',7)
                ii=findstr(s,'='); Nquan=str2num(s(ii+1:end));
            end
            if strncmp(s,'# file_type',11)
                ii=findstr(s,'binary'); if ~isempty(ii); asc_bin=1; end 	       
            end	 
            if strncmp(s,'# start_time',12) 
                t1=deblank(s(16:length(s)));
                time=Zeitdecode(t1);
                HeaderU=strvcat(HeaderU,deblank(s(3:length(s))));
            end
        else
            jheader=jheader-1;
        end      
    end
    idata=0;
    if nzyk==0
        DATA=[]; imax=0
    elseif asc_bin==1
        def =-9.990000242327645e-29; % da die im header angegeben -9.990000000000000e-29
        % nicht so eingelesen werden
        imax=10000;
        DATA=zeros(imax,Nquan);
        idata=0;
        while 1
            idata=idata+1;
            if idata>imax;
                DATA=[DATA; zeros(10000,Nquan)];
                imax=imax+10000;
            end
            a=fread(fid,Nquan,'float32')';
            ii=a==def; a(ii)=NaN;
            if isempty(a); idata=idata-1; break; end
            DATA(idata,:)=a;
        end 
    else
        % Aenderung 29.1.2002; auch nach dem *END des Headers
        % wird text gelesen, bis eine Zeile mit einer Zahl anfaengt
        % !diese zeilen werden aber auch mit nzyk=-1 nicht uebernommen
        ssi=0; while(ssi==0)
          s=fgetl(fid);  
	  if ~ischar(s), 
	    DATA=[]; 
	    warning(['unexpected End of File (DATA):' Datei]);
	    return
	  end
          ss=[strjust(s,'left') ' ']; 
          ssi=sum(strcmp(ss(1),{'0','1','2','3','4','5','6','7','8','9'}));
        end
        a=eval([ '[ ' s ']']);
        ii=length(a); imax=5000;
        DATA=zeros(imax,ii);
        idata=1; Izyk=1;
        DATA(idata,:)=a;
        while 1
            s=fgetl(fid);
            if ~isstr(s); break; end
            Izyk=Izyk+1;
            if mod(Izyk,nzyk) ==0
                idata=idata+1; 
                if idata>imax;
                    DATA=[DATA; zeros(10000,Nquan)];
                    imax=imax+10000;
                end
                [A,count] = sscanf(s,'%f');
                ii=A==def; A(ii)=NaN;
                DATA(idata,:)=A';
            end      
        end
    end
    if idata<imax; DATA=DATA(1:idata,:); end
    fclose(fid);
    [lat,lon,wtiefe]=sbepos(HeaderU);
end
if nzyk~=(-1) & length(HeaderU)>0; Header=HeaderU; end

if nzyk~=0;
    itime=0;
    [in,jn]=size(Namen);
    for i2=1:in
        if itime==0; i3=findstr(Namen(i2,:),'ulian'); if ~isempty(i3); itime=i2; end; end
    end
    if itime>0 & DATA(1,itime)>datenum('1/1/1900') & DATA(1,itime)<datenum('1/1/2100')
        DATA(:,itime)=DATA(:,itime)+julday(1,1,-1);
    end
    if itime>0 & DATA(1,itime)<400 & length(time)>2
        DATA(:,itime)=DATA(:,itime)+julday(12,31,time(3)-1);
    end   
end

%      if ipres==0; i3=findstr(n(i2,:),'ressu'); if ~isempty(i3); ipres=i2; end; end
%      if itemp==0; i3=findstr(n(i2,:),'emper'); if ~isempty(i3); itemp=i2; end; end
%      if icond==0; i3=findstr(n(i2,:),'onduc'); if ~isempty(i3); icond=i2; end; end
%    end


if nzyk>0 & asc_bin==0 & ~(strcmp(EXT,'.cdf') | strcmp(EXT,'.nc')) & ~(exist(fullfile(PATH,[NAME '.mat',VER]))==2)
    ii=fopen(fullfile(PATH,[NAME '.mat',VER]),'w');  % um zu ueberpruefen, ob wir ueberhaupt schreiben durfen
    if ii>0;
        fclose(ii);
        save(fullfile(PATH,[NAME '.mat',VER]),'DATA','Header','Namen','time','lat','lon','wtiefe');
    end
end
% for matlab 5; if strjust(,'left') is not defined
%        ss=[strjust(s) ' '];
%        ii1=1; for ii1=1:length(ss);
%           if ss(1:1)==' '; ss=ss(2:end); end
%        end 


function time=Zeitdecode(t1)
eval('time=datenum(t1);','time=[];');
if isempty(time);
    ii=findstr(t1,'Okt'); 
    if ~isempty(ii); t1(ii(1):ii(1)+2)='Oct'; end  
    ii=findstr(t1,'Mai'); 
    if ~isempty(ii); t1(ii(1):ii(1)+2)='May'; end  
    eval('time=datenum(t1);','time=[];');
end
if isempty(time);
    ii=findstr(t1,'.');
    if ~isempty(ii); t1(ii)='-'; end
    eval('time=datenum(t1);','time=[];');
end       
if isempty(time);                    
    warning(['Time could not be read. String:',t1]);
    fprintf('known time formats and example:\n')
    fprintf(' dd-mmm-yyyy HH:MM:SS   01-Mar-2000 15:45:17 \n')
    fprintf(' dd-mmm-yyyy             01-Mar-2000  \n')
    fprintf(' mm/dd/yy                03/01/00    \n') 
    fprintf(' mm/dd/yyyy              03/01/2000 \n')
    while isempty(time)
        t1=input('Give right Time String:','s');
        eval('time=datenum(t1);','time=[];');
    end                    
end
time=datevec(time);time=time([3 2 1 4 5 6]);
