% sb_plot
% praktisches UI zum Erstellen verschiedenster Plots
%
% geschrieben von J.Holfort
%
% letzte Version: 05.09.2003 M.Kreus

iiextra1=0;

if exist('sw_ptmp')~=2
 error('Bitte CSIRO seawater M-Dateien zum Pfad hinzunehmen')
end

sb_ui;

if iscell(DISK);
    datei=[]; iprof=0;
    for ijh=1:length(DISK);
        dummy=mk4file(DISK{ijh});
        if length(dummy)>0
            iprof=iprof+length(dummy)
            datei=[datei dummy];
        end
    end
    Prof=[1:iprof];
elseif strcmp(NAME(1:1),'*')==1
  datei=mk4file(NAME,DISK);
  iprof=length(datei);
  Prof=[1:iprof];
else
  datei=mk4file(DISK,NAME,PROF,EXT,2);
  iprof=length(datei);
  Prof=[1:iprof];
end

switch plotart
 case {1 4}
  %fprintf('Farben der einzelnen Profile \n');
  [ART,FARBEN,SIZE]=iso_marker(Prof,SW);%keyboard;
 case 2
  Ypres=[]; ARR=[]; Ygrid=[ 0 0 Mitteln(1)];
  if Ygrid(3)<=0; Ygrid(3)=5; end
 case 3
  Ygrid=[];
  while length(Ygrid)<3 | length(Ygrid)>4
  Ygrid=input('Min,Max,Step fr die Gridpunkte in Yrichtung z.B. [0 1000 10] : ');
  end
  Ypres=[]; ARR=[];
 case 5
     % Topographieauswahl
 otherwise
   error('falsche plotart')
end

% Daten Einlesen
X=cell(1,1); Y=cell(1,1); Z=cell(1,1);
IP=0; clear D P 
for iP=1:iprof
  a=[]; 
  Datei=datei{iP};
  [a,h,n,time,lat,lon,wt]=sberead(Datei);
%  if iscell(DISK) | strcmp(NAME(1:1),'*')==1
%      Datei=datei{iP};
%      [a,h,n,time,lat,lon,wt]=sberead(Datei);
%  else
%      if iP<0
%          Datei=[DISK NAME EXT];
%          [a,h,n,time,lat,lon,wt]=sberead(Datei);
%      end
%      if isempty(a); 
%          Datei=mk4file(DISK,NAME, Prof(iP),EXT,2);
%          %if exist(Datei,'file')~=2 & Prof(iP)<100;
%          %   Datei=[DISK NAME sprintf('%2.2i',Prof(iP)) EXT];
%          %   if exist(Datei,'file')~=2 & Prof(iP)<10;
%          %      Datei=[DISK NAME sprintf('%1.1i',Prof(iP)) EXT];
%          %   end
%          %end
%          [a,h,n,time,lat,lon,wt]=sberead(Datei);
%      end
%      if isempty(a); 
%        fprintf('Datei nicht vorhanden, Nummer:%5i\n',Prof(iP));
%      end
%  end
  if ~isempty(a); 
    fprintf('Datei:%s \n   Header1:%s \n',Datei,h(1,:))
    IP=IP+1;
    D(IP).name=Datei;
    D(IP).lat=lat;
    D(IP).lon=lon;
    if plotart==5; continue; end
    if isempty(wt); wt=20000; end
    if wt<0; wt=12000; end
    D(IP).wtiefe=sw_pres(wt,lat);    % Wtiefe in dbar
    
    [mm,nn]=size(a);    
    [a,n]=sb_eiche(a,n);
    
    IV=SBvar_pos(n);
    Ipres=IV(1) ; Itemp=IV(2); Icond=IV(3); Isalz=IV(4);  Ioxyg=IV(5); Ioc=IV(6); Iotem=IV(7);
    % In IV stehen die Positionen von 
    % 'PRES','TEMP','COND','S','OXYG','oxC','oxT'

    % Oberflche entfernen
    rr=find(a(:,Ipres)<Obenweg);
    if ~isempty(rr); a(rr,:)=NaN; end

    % HievAnteile entfernen
    if Hievweg==1
        while 1>0 
            rr=find(diff(a(:,Ipres))>0);  
            if length(rr)+1 ~=length(a(:,Ipres)) ; 
                a=a(rr,:); 
            else
                break
            end
            if length(rr)==0; break; end
        end
        clear rr   
        [mm,nn]=size(a);
    end
       
    
    %---------------------------------------------------------------------------------------
    %--------------------------------------------------------------------------------------- 
    %--------------------------------------------------------------------------------------- 
    %--------------------------------------------------------------------------------------- 
    
    % Mitteln auf feste dbar Abstnde
    % Fenstergroesse=r gibt an das Werte im Abstand +-r vom
    % zu interpolierenden Wert fuer die Mittelung benutzt werden sollen
    % bei nur einem Wert ist Fenstergroesse = Abstand
    if Mitteln(1)>0
        a=mitteln(a,[0 0 Mitteln],Ipres);
        [mm,nn]=size(a);
    end
    
    if (mm<1 | nn<1) 
        IP=IP-1;   % Profile ohne Daten werden ganz weggelassen
    else    % nur falls Daten berhaupt da
        
    % falls Icond>0 ist kein salzgehalt vorhanden
    % daher berechnen und damit cond ueberschreiben
    %if Icond>0 & Isalz<=0
    %  Isalz=Icond; for ii=1:length(n(Isalz,:)); n(Isalz,ii)=' '; end; n(Isalz,1:4)='Salz';
    %  if findstr(n(Icond,:),'[S/m]')>0; C1535=4.2914; else C1535=42.914; end
    %  a(:,Isalz)=sw_salt(a(:,Icond)/C1535,a(:,Itemp),a(:,Ipres));
    %end	
    
    
    %--------------------------------------------------------------------------------------- 
    %--------------------------------------------------------------------------------------- 
    %--------------------------------------------------------------------------------------- 
    %--------------------------------------------------------------------------------------- 
    
    % noch berprfen, ob wtiefe==0 oder PRESmax grer als Header-Tiefe
    if D(IP).wtiefe==0 | D(IP).wtiefe<max(a(:,Ipres))
        D(IP).wtiefe=max(a(:,Ipres));
    end
    
    % bisher ist dies mit global nur bedingt gebrauchbar, da nur eine Variable
    % moeglich, nicht aber z.B. ixx==16 und iyy==16
    if (iiz==17 & iix==17) | (iiz==17 & iiy==17) | (iix==17 & iiy==17)
          error('bisher nur jeweils eine interne Variable mglich');
    end
    if (iix==17 | iiy==17 | iiz==17) & iiextra1==0;
        global sbVARNAM
        nn=[ cellstr(n)];
        i=menu('welche Variable:',nn);
        sbVARNAM=nn(i);
        iiextra1=1;
    end

    % Daten entsprechend Plotart einlesen
    switch plotart
     case 1
      % 1) x-y-plots
      X(IP)={sbvariable(iix,a,n,lat)};
      Y(IP)={sbvariable(iiy,a,n,lat)};
     case {2,3}
      % 2) contour Plot (Schnitte)
      % Ypres ist die Tiefenachse; 
      % grid_y darf nicht sein (1)==(2) und (3)<0
      y=sbvariable(iiy,a,n,lat);
      z=sbvariable(iiz,a,n,lat);
      a=mitteln([y z],Ygrid,1);
      if isempty(a); IP=IP-1; continue; end   % 3/2004 extra noch zu verbessern
      Z(IP)={a(:,2)};
      if Ygrid(1)==Ygrid(2) | IP==1 ; % dieses 'if' nur um memory und zeit zu sparen
         Y(IP)={a(:,1)};
      end
     case 4
      % 4) x,y,z plot (bisher color codiert nach Station)
      X(IP)={sbvariable(iix,a,n,lat)};
      Y(IP)={sbvariable(iiy,a,n,lat)};
      Z(IP)={sbvariable(iiz,a,n,lat)};
     otherwise
      error('unbekannte Plotart')
    end
    end
  end
end

% jetzt kommt das eigentliche Plotten 
if plotart==1
   figure;
   for ii=1:IP
      plot(X{ii},Y{ii},char(ART(ii)),'color',FARBEN(ii,:),'markersize',SIZE(ii));
      hold on
   end   
   xlabel(textx);
   ylabel(texty);
   if iix==2 & iiy==4; dichtecontour; end
   if iiy==0; axis('ij'); end
elseif plotart==4
   figure;
   for ii=1:IP
      h=plot3(X{ii},Y{ii},Z{ii})
      set(h,'marker',char(ART(ii)),'color',FARBEN(ii,:),'markersize',SIZE(ii));
      hold on
   end
   xlabel(textx);
   ylabel(texty);
   zlabel(textz);
elseif plotart==5
   figure; 
   Y=struc2arr(D,'lat');   X=struc2arr(D,'lon');
   xdif=min(1,(max(X)-min(X))/10); ydif=min(1,(max(Y)-min(Y))/10); 
   xdif=max(xdif,0.1); ydif=max(ydif,0.1);
   topoplot([min(X)-xdif max(X)+xdif min(Y)-ydif max(Y)+ydif],[-10000:1000:0],[],2)
   hold on
   a=axis; loffset=0; 
   if a(1)>min(X); loffset=360; end
   if a(2)<max(X); loffset=-360; end
   plot(X+loffset,Y,'+'); 
   text(X+loffset,Y,num2str(PROF'),'rotation',45,'erasemode','xor','tag','poslabel')
else
   if plotart==2 | plotart==3
      ARR=Z{1}; Ypres=Y{1};
      if length(Y)==1
         for ii=2:IP
           ARR=anpapp(ARR,Z{ii});
         end
      else
         for ii=2:IP
           [ARR,Ypres]=anpapp(ARR,Z{ii},Ypres,Y{ii});
         end
      end  
   end
   pos_ui;
   
   % Positionen und Wassertiefe korregieren
   P.X(1)=0;
   if XVAR<=0
      for ii=2:IP
         d=sw_dist([D(ii).lat D(ii-1).lat],[D(ii).lon D(ii-1).lon],'km');
         P.X(ii)=P.X(ii-1)+d;
      end
   elseif XVAR==1
      P.X=[1:length(D)];
   elseif XVAR==2
      P.X=struc2arr(D,'lat');
      [P.X i]=sort(P.X);
      D=D(i);
      ARR=ARR(:,i);
   elseif XVAR>=3
      P.X=struc2arr(D,'lon');
      [P.X i]=sort(P.X);
      D=D(i);
      ARR=ARR(:,i);
   end

   if plotart==2;
      P.Y=Ypres;
      P.Grid=arrfill(ARR);
      idum=size(P.X); if idum(2)==1; P.X=P.X'; end
      P.Boden=[P.X; struc2arr(D,'wtiefe')'];
   else
      P.Y=Ypres;
      P.Grid=ARR;
   end

   if plotart==2
      % Berechnung der Geschwindigkeit hin,
      % falls man als Contour Variable die Anomalie des Geopotentials gewhlt hat
      LNM=-1;
      if iiz==13
         LNM=input(['LNM fr Geschwindigkeiten, bzw. <0 fr Geopot.' ...
               ' Anomalie ?']);
         if isempty(LNM); LNM=-1; end
      end
      if LNM(1)>0
         % ARR=arrfill(ARR);
         vel=sw_gvel(ARR,...
            struc2arr(D,'lat'),struc2arr(D,'lon'))*100;
         [i1,j1]=size(vel);
         if length(LNM)==j1
            for jj=1:j1
               [m,ilnm(jj)]=min(abs(Ypres-LNM(jj)));
            end
         else
            [m,i]=min(abs(Ypres-LNM(1)));
            ilnm=ones(j1,1)*i;
         end
         if length(LNM)>j1 & length(LNM)~=j1;
            fprintf('LNM muss entweder eins, oder hier=%i sein \n',j1)
         end


         for jj=1:j1
            if isnan(vel(ilnm(jj),jj))
               [m,i1]=max(find(~isnan(vel(:,jj))));
               if ~isempty(i1); vel(:,jj)=vel(:,jj)-vel(i1,jj); end
            else
               vel(:,jj)=vel(:,jj)-vel(ilnm(jj),jj);
            end
         end
         P.Grid=[vel(:,1) vel vel(:,end)];
         P.X(1)=0; P.X(IP+1)=P.X(IP);
         for ii=2:IP
            P.X(ii)=(P.X(ii-1)+P.X(ii))/2.;
         end
         textz='velocity [cm/s]';
      end
   end
   if SW==4; SW=[]; end  % dann auswahl in mk4ins
   mk4ins(P,[],SW,textz,0,[0.1 0.1 0.1]);
   if XVAR==0;
      xlabel('aufsummierte Stationsabstnde [km]')
   elseif XVAR==1
      xlabel('Zeit')
   elseif XVAR==2
      xlabel('Breite')
   elseif XVAR==3
      xlabel('Lnge')
   end
    ylabel('Druck in dbar')
   if plotart==3; ylabel(texty); end
end
hold off
