function [x,name]=sbvariable(ivar,a,Vnamen,LAT)
% Eingabe:
%  ivar= Gewnschte Variable, bzw. <0 fr Auswahl ( dann ohne Berechnung,
%          und gibt in x die Ivar-Nummer des gewnschten Parameters)
%        Falls als einzige Eingabe nur Ivar ist, ist x=ivar
%  a   = Array in dem Druck,Temp,S und gegebenenfalls Sauerstoff steht
%  Vnamen, die Namen der Variablen im Array a, daraus wird
%    Ipres,Itemp,Isalz,Ioxyg = Position von Druck, Temp., Salz und Sauerstoff
%    im Array a berechnet
%  LAT = Breite, nur ntig bei N^2, Pot.Vorticity
% Ausgabe:
%  x = berechnete Variable, bzw. bei ivar<0 Variablennummer
%  name = Text zur Characterisierung der Variablen  

% Temperatur wird bisher immer noch in IPTS-68 angenommen 

% so koenne die Variablen auch angesprochen werden
VnamX={'PRES','TEMP','S','OXYG','PTEM','SNDV','SIGT',...
        'SIG1','SIG2','SIG4','N**2','PVOR','AOU','ANOM',...
        'Pbot','SIG3','DEPT','Salz','T90'};
if nargin>2
    if iscell(Vnamen); Vnamen=char(Vnamen); end
end
if ischar(ivar)
    jj=-1;
    for ii=1:length(VnamX)
        if strcmp(ivar,VnamX{ii})
            jj=ii-1;
            break
        end
    end
    if jj<0; error('unknown name'); end
    ivar=jj;
    if ivar==17; ivar=2; end %Salz
    if ivar==18; ivar=1; end %T90 noch TEMP
end
if ivar<0 
   x=menu('Variablenauswahl','Druck','Temperatur','Salz',...
      'Sauerstoff','pot. Temp.','Schallgeschwindigkeit',...
      'sigma theta','sigma-1','sigma-2','sigma-4',...
      'N**2','pot.Vorticity','AOU','geopot. Anomaly',...
      'Pmax-P','sigma-3','DPETH','INTERNE'); 
   x=x-1;  % da nachher ivar=0 Druck is
   ivar=x;
   if ivar==17
       global sbVARNAM
       %sbVARNAM=input('gewuenschte Variable','s'),
       %i=menu('welche Variable:',a);
       sbVARNAM='Intern'
   end
end
if nargout>1   
   TEXT=[{'Druck (dbar)'},{'Temperatur (C)'},...
      {'Salzgehalt'},...
      {'O_2 (umol/l)'},...
      {'\theta (C)'},...
      {'v_{Schall}(m/s)'},...
      {'\sigma_{\theta}'},...
      {'\sigma_1'},...
      {'\sigma_2'},...
      {'\sigma_4'},...
      {'N^2'},...
      {'pot. Vorticity'},...
      {'AOU [\mumol/kg]'},...
      {'Geopotential anomaly'},...
      {'Distance from Pmax [dbar]'},...
      {'\sigma_3'},{'depth [m]'}...
      {'XXXX'}];
  name=TEXT(ivar+1);   
  if ivar==16
       if exist('sbVARNAM')==0; global sbVARNAM ; end
       name=sbVARNAM
   end
end   

if nargin==1; x=ivar; return; end

if ivar==3 | ivar==12 
   IV=SBvar_pos(Vnamen);
else
   IV=SBvar_pos(Vnamen,4);
end
Ipres=IV(1) ; Itemp=IV(2); Icond=IV(3); Isalz=IV(4);  Ioxyg=IV(5); Ioc=IV(6); Iotem=IV(7);
if Ipres==0; 
    warning('in sbvariable; Druck muss vorhanden sein'); x=a(:,1)+NaN; return
end
if Itemp==0; 
    warning('in sbvariable; Temperatur muss vorhanden sein');  x=a(:,1)+NaN; return
end
if Isalz==0; 
  if Icond==0; 
      warning('in sbvariable; Salz oder Leitfhigkeit muss vorhanden sein');  x=a(:,1)+NaN; return
  end
  a(:,Icond)=sw_salt(a(:,Icond)/sw_c3515,a(:,Itemp),a(:,Ipres));
  Isalz=Icond; Icond=0;
end

if ivar==0
  x=a(:,Ipres); 
elseif ivar==1
  x=a(:,Itemp); 
elseif ivar==2
  x=a(:,Isalz);
elseif ivar==3
   if Ioxyg<=0; 
      x=a(:,Ipres)*NaN; 
   else
      %ml2umol=1000./22.4;
      %x=a(:,Ioxyg)*ml2umol;
      x=a(:,Ioxyg); 
   end
elseif ivar==4   
  x=sw_ptmp(a(:,Isalz),a(:,Itemp),a(:,Ipres),0);
elseif ivar==5   
  x=sw_svel(a(:,Isalz),a(:,Itemp),a(:,Ipres));
elseif ivar==6
  x=sw_pden(a(:,Isalz),a(:,Itemp),a(:,Ipres),0) -1000;
elseif ivar==7
  x=sw_pden(a(:,Isalz),a(:,Itemp),a(:,Ipres),1000)-1000;
elseif ivar==8
  x=sw_pden(a(:,Isalz),a(:,Itemp),a(:,Ipres),2000)-1000;
elseif ivar==9
  x=sw_pden(a(:,Isalz),a(:,Itemp),a(:,Ipres),4000)-1000;
elseif ivar==10 | ivar==11   
  [bfrq,vort] = sw_bfrq(a(:,Isalz),a(:,Itemp),a(:,Ipres),LAT);
  % da sw_bfrq die resultate zwischen den Tiefen liefert, wird
  % zur angleichung der Dimensionen hier das Profil verschoben
  % (d.h. halbe Tiefenstufe nach oben) und ein NaN angehngt
  if ivar==10; x=[bfrq*1E4;NaN]; 
  else         x=[vort*1E9;NaN]; end
  clear bfrq vort
elseif ivar==12
   if Ioxyg<=0; x=a(:,Ipres)*NaN; 
   else 
      ml2umol=1000./22.4; ml2umol=1;    
      r=ox_kg(a(:,Itemp),a(:,Isalz));
      x=r- ( a(:,Ioxyg).*ml2umol .* ...
         1000./sw_pden(a(:,Itemp),a(:,Isalz),a(:,Ipres),0));
   end 
elseif ivar==13
   ii= ~isnan(a(:,Isalz)) & ~isnan(a(:,Itemp)) & ~isnan(a(:,Ipres));
   x=a(:,Isalz)*NaN;
   x(ii)= sw_gpan(a(ii,Isalz),a(ii,Itemp),a(ii,Ipres));
elseif ivar==14
   Pmax=max(a(:,Ipres));
   x=Pmax-a(:,Ipres);
elseif ivar==15
   x=sw_pden(a(:,Isalz),a(:,Itemp),a(:,Ipres),3000)-1000;
elseif ivar==16
   x=sw_dpth(a(:,Ipres),LAT);
elseif ivar==17
    %keyboard
   global sbVARNAM
   ii=find(strcmp(sbVARNAM,cellstr(Vnamen)));
   if ii>0; x=a(:,ii); else x=a(:,1)+NaN; end
else
  %break
end

