function x=zeitk(x,t,n1,n2,rk)
%c        zeitkonstantenkorrektur
%c        eingabe:
%c                x(n)  variable auf die die zeitkonstante angewendet werden
%c                        soll
%c                t(n)  zu x(n) zugehrige zeitpunkte, muss streng monoton
%c                        steigend oder fallend sein
%c                n1    erster wert fr berechnung, muss >0 sein
%c                n2    letzter wert fr berechnung, muss kleiner sein als
%c                   dimension von x und t
%c                rk    zeitkonstante
%c        ausgabe:
%c                x(n)  mit der zeitkonstanten rk verlangsamte eingabe-
%c                        variable x(n), wobei nur zwischen n1 und n2
%c                     verlangsamt(falls n1 nicht=1 ist)
%c        standard fortran 77 mit do-endo schleifen
%c        copyright jrgen holfort, ifm-kiel, 1991
%C SAVE nicht notwendig
% Von Fortran auf matlab umbeschrieben 
   if rk<0;  warning(' zeitkonstante<0 '); return;  end
   if rk==0; return; end
   if n1<2; n1=2; end
   if n2>length(x); n2=length(x); end
   for i=n1:n2
       x(i)=x(i) - (x(i)-x(i-1))*exp( -abs(t(i)-t(i-1)) /rk );
   end

